package com.biz.crm.mdm.business.channel.org.employee.local.service;


import com.biz.crm.mdm.business.channel.org.employee.local.entity.ChannelOrgEmployee;
import java.util.List;

/**
 * 渠道组织员工表(ChannelOrgEmployee)表服务接口
 *
 * @author songjingen
 * @since 2022-11-23 10:32:48
 */
public interface ChannelOrgEmployeeService{
  
   /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  ChannelOrgEmployee findById(String id);
  
   /**
   * 新增数据
   * @param channelOrgEmployees 实体对象
   * @return 新增结果
   */
  List<ChannelOrgEmployee> create(List<ChannelOrgEmployee> channelOrgEmployees);
  
  /**
   * 逻辑删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);
  
  /**
   * 启用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 启用结果
   */
  void enable(List<String> idList);
  
  /**
   * 禁用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 禁用结果
   */
  void disable(List<String> idList);
}

