package com.biz.crm.mdm.business.channel.org.employee.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.channel.org.employee.local.entity.ChannelOrgEmployee;
import com.biz.crm.mdm.business.channel.org.employee.local.repository.ChannelOrgEmployeeRepository;
import com.biz.crm.mdm.business.channel.org.employee.sdk.dto.ChannelOrgEmployeePaginationDto;
import com.biz.crm.mdm.business.channel.org.employee.sdk.event.EngineEmployeeEventListener;
import com.biz.crm.mdm.business.channel.org.employee.sdk.service.ChannelOrgEmployeeVoService;
import com.biz.crm.mdm.business.channel.org.sdk.vo.ChannelOrgVo;
import com.biz.crm.workflow.sdk.dto.UserInfoEventDto;
import com.biz.crm.workflow.sdk.vo.response.UserInfoResponse;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 渠道员工vo实现类
 *
 * @author songjingen
 */
@Service
public class ChannelOrgEmployeeVoServiceImpl implements ChannelOrgEmployeeVoService {

  @Autowired(required = false)
  private ChannelOrgEmployeeRepository channelOrgEmployeeRepository;
  @Autowired(required = false)
  private NebulaNetEventClient nebulaNetEventClient;

  @Override
  public List<String> findUserCodesByChannelOrgCode(String channelOrgCode) {
    if (StringUtils.isBlank(channelOrgCode)) {
      return new ArrayList<>(0);
    }
    List<ChannelOrgEmployee> channelOrgEmployees = this.channelOrgEmployeeRepository.findByChannelOrgCode(channelOrgCode);
    if (CollectionUtils.isEmpty(channelOrgEmployees)) {
      return new ArrayList<>();
    }
    return channelOrgEmployees.stream().map(ChannelOrgEmployee::getUserCode).collect(Collectors.toList());
  }

  @Override
  public Page<ChannelOrgVo> findByConditions(Pageable pageable, ChannelOrgEmployeePaginationDto channelOrgEmployeePaginationDto) {
    return null;
  }

  @Override
  public UserInfoResponse findAllChildrenByOrgCode(List<String> orgCodeList) {
    //查询B2b人员
    UserInfoEventDto dto = UserInfoEventDto.builder().orgCodes(orgCodeList).build();
    SerializableBiConsumer<EngineEmployeeEventListener, UserInfoEventDto> sf =
        EngineEmployeeEventListener::findAllChildrenByOrgCodes;
    UserInfoResponse userInfoResponse =(UserInfoResponse)
        this.nebulaNetEventClient.directPublish(dto, EngineEmployeeEventListener.class, sf);
    return  userInfoResponse;
  }
}
