package com.biz.crm.mdm.business.channel.org.employee.local.strategy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.mdm.business.channel.org.employee.local.register.ChannelOrgRelationEmployeeRegister;
import com.biz.crm.mdm.business.channel.org.employee.sdk.event.ChannelOrgEmployeeInfoEventDto;
import com.biz.crm.mdm.business.channel.org.employee.sdk.service.ChannelOrgEmployeeVoService;
import com.biz.crm.mdm.business.channel.org.sdk.strategy.ChannelOrgRelationStrategy;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 渠道组织关联门店策略实现类
 */
@Component
public class ChannelOrgRelationEmployeeStrategy implements ChannelOrgRelationStrategy {

  @Autowired(required = false)
  private ChannelOrgRelationEmployeeRegister channelOrgRelationEmployeeRegister;
  @Autowired(required = false)
  private ChannelOrgEmployeeVoService channelOrgEmployeeVoService;
  @Autowired(required = false)
  private UserVoService userVoService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public String getKey() {
    return this.channelOrgRelationEmployeeRegister.getKey();
  }

  @Override
  public JSONArray findByChannelOrgChannel(String channelOrgCode) {
    if (StringUtils.isBlank(channelOrgCode)) {
      return null;
    }
    List<String> userCodes = channelOrgEmployeeVoService.findUserCodesByChannelOrgCode(channelOrgCode);
    if (CollectionUtils.isEmpty(userCodes)) {
      return null;
    }
    List<UserVo> userVos = this.userVoService.findByUserCodes(Sets.newHashSet(userCodes));
    if (CollectionUtils.isEmpty(userVos)) {
      return null;
    }
    List<ChannelOrgEmployeeInfoEventDto> channelOrgEmployeeEventDtos = (List<ChannelOrgEmployeeInfoEventDto>) this.nebulaToolkitService.copyCollectionByWhiteList(userVos, UserVo.class,
        ChannelOrgEmployeeInfoEventDto.class, HashSet.class,
        ArrayList.class);
    return JSONArray.parseArray(JSON.toJSONString(channelOrgEmployeeEventDtos));
  }
}
