/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.channel.org.employee.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.channel.org.employee.local.entity.ChannelOrgEmployee;
import com.biz.crm.mdm.business.channel.org.employee.local.service.ChannelOrgEmployeeService;
import com.biz.crm.mdm.business.channel.org.employee.sdk.service.ChannelOrgEmployeeVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/channelOrgEmployee/channelOrgEmployee"})
@Api(tags={"\u6e20\u9053\u7ec4\u7ec7\u5458\u5de5\u8868\uff1aChannelOrgEmployee\uff1a\u6e20\u9053\u7ec4\u7ec7\u5458\u5de5\u8868"})
public class ChannelOrgEmployeeController {
    private static final Logger log = LoggerFactory.getLogger(ChannelOrgEmployeeController.class);
    @Autowired
    private ChannelOrgEmployeeService channelOrgEmployeeService;
    @Autowired(required=false)
    private ChannelOrgEmployeeVoService channelOrgEmployeeVoService;

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<ChannelOrgEmployee> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            ChannelOrgEmployee channelOrgEmployee = this.channelOrgEmployeeService.findById(id);
            return Result.ok((Object)((Object)channelOrgEmployee));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<List<ChannelOrgEmployee>> create(@ApiParam(name="channelOrgEmployee", value="\u6e20\u9053\u7ec4\u7ec7\u5458\u5de5\u8868") @RequestBody List<ChannelOrgEmployee> channelOrgEmployees) {
        try {
            List<ChannelOrgEmployee> result = this.channelOrgEmployeeService.create(channelOrgEmployees);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u6570\u636e\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.channelOrgEmployeeService.delete(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"enable"})
    @ApiOperation(value="\u542f\u7528\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> enable(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> ids) {
        try {
            this.channelOrgEmployeeService.enable(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"disable"})
    @ApiOperation(value="\u7981\u7528\uff08\u5355\u4e2a\u6216\u8005\u6279\u91cf\uff09")
    public Result<?> disable(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> ids) {
        try {
            this.channelOrgEmployeeService.disable(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"findUserCodesByChannelOrgCode"})
    public Result<List<String>> findUserCodesByChannelOrgCode(@RequestParam @ApiParam(name="channelOrgCode", value="\u6e20\u9053\u7ec4\u7ec7\u7f16\u7801") String channelOrgCode) {
        try {
            List userCodes = this.channelOrgEmployeeVoService.findUserCodesByChannelOrgCode(channelOrgCode);
            return Result.ok((Object)userCodes);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

