/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.channel.org.employee.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.channel.org.employee.local.entity.ChannelOrgEmployee;
import com.biz.crm.mdm.business.channel.org.employee.local.repository.ChannelOrgEmployeeRepository;
import com.biz.crm.mdm.business.channel.org.employee.local.service.ChannelOrgEmployeeService;
import com.biz.crm.mdm.business.channel.org.employee.sdk.event.ChannelOrgEmployeeEventDto;
import com.biz.crm.mdm.business.channel.org.employee.sdk.event.ChannelOrgEmployeeEventListener;
import com.biz.crm.mdm.business.channel.org.employee.sdk.event.ChannelOrgEmployeeInfoEventDto;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="channelOrgEmployeeService")
public class ChannelOrgEmployeeServiceImpl
implements ChannelOrgEmployeeService {
    @Autowired
    private ChannelOrgEmployeeRepository channelOrgEmployeeRepository;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private UserVoService userVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public ChannelOrgEmployee findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ChannelOrgEmployee orgEmployee = (ChannelOrgEmployee)((Object)this.channelOrgEmployeeRepository.getById((Serializable)((Object)id)));
        return orgEmployee;
    }

    @Override
    @Transactional
    public List<ChannelOrgEmployee> create(List<ChannelOrgEmployee> channelOrgEmployees) {
        Validate.isTrue((!CollectionUtils.isEmpty(channelOrgEmployees) ? 1 : 0) != 0, (String)"\u65b0\u589e\u65f6\uff0c\u6570\u636e\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Map<String, ChannelOrgEmployee> employeeMap = channelOrgEmployees.stream().collect(Collectors.toMap(o -> StringUtils.joinWith((String)o.getChannelOrgCode(), (Object[])new Object[]{o.getUserCode()}), o -> o));
        Validate.isTrue((employeeMap.size() == channelOrgEmployees.size() ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5b58\u5728\u540c\u4e00\u6e20\u9053\u7ec4\u7ec7\u5173\u8054\u591a\u4e2a\u76f8\u540c\u7684\u4f01\u4e1a\u7528\u6237\uff01", (Object[])new Object[0]);
        Set<String> channelOrgCodes = channelOrgEmployees.stream().map(ChannelOrgEmployee::getChannelOrgCode).collect(Collectors.toSet());
        Set<String> userCodes = channelOrgEmployees.stream().map(ChannelOrgEmployee::getUserCode).collect(Collectors.toSet());
        List<ChannelOrgEmployee> currentEmployeeList = this.channelOrgEmployeeRepository.findByUserCodesAndChannelOrgCodes(userCodes, channelOrgCodes);
        Map<Object, Object> currentMap = new HashMap();
        if (!CollectionUtils.isEmpty(currentEmployeeList)) {
            currentMap = currentEmployeeList.stream().collect(Collectors.toMap(o -> StringUtils.joinWith((String)o.getChannelOrgCode(), (Object[])new Object[]{o.getUserCode()}), o -> o));
        }
        for (ChannelOrgEmployee channelOrgEmployee : channelOrgEmployees) {
            this.createValidate(channelOrgEmployee);
            Validate.isTrue((currentMap.get(StringUtils.joinWith((String)channelOrgEmployee.getChannelOrgCode(), (Object[])new Object[]{channelOrgEmployee.getUserCode()})) == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5b58\u5728\u540c\u4e00\u6e20\u9053\u7ec4\u7ec7\u5173\u8054\u591a\u4e2a\u76f8\u540c\u7684\u4f01\u4e1a\u7528\u6237\uff01", (Object[])new Object[0]);
        }
        this.channelOrgEmployeeRepository.saveBatch(channelOrgEmployees);
        ChannelOrgEmployeeEventDto channelOrgEmployeeEventDto = new ChannelOrgEmployeeEventDto();
        List userVos = this.userVoService.findByUserCodes(userCodes);
        if (!CollectionUtils.isEmpty((Collection)userVos)) {
            List channelOrgEmployeeInfoEventDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)userVos, UserVo.class, ChannelOrgEmployeeInfoEventDto.class, HashSet.class, ArrayList.class, new String[0]);
            ChannelOrgEmployee channelOrgEmployee = channelOrgEmployees.get(0);
            channelOrgEmployeeEventDto.setChannelOrgCode(channelOrgEmployee.getChannelOrgCode());
            channelOrgEmployeeEventDto.setChannelOrgName(channelOrgEmployee.getChannelOrgName());
            channelOrgEmployeeEventDto.setChannelOrgEmployeeInfoEventDtoList(channelOrgEmployeeInfoEventDtos);
            SerializableBiConsumer & Serializable onCreate = ChannelOrgEmployeeEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)channelOrgEmployeeEventDto, ChannelOrgEmployeeEventListener.class, (SerializableBiConsumer)onCreate);
        }
        return channelOrgEmployees;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ChannelOrgEmployee> channelOrgEmployees = this.channelOrgEmployeeRepository.findByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty(channelOrgEmployees) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u5220\u9664\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        channelOrgEmployees.stream().forEach(channelOrgEmployee -> channelOrgEmployee.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
        this.channelOrgEmployeeRepository.saveOrUpdateBatch(channelOrgEmployees);
        ChannelOrgEmployeeEventDto channelOrgEmployeeEventDto = new ChannelOrgEmployeeEventDto();
        ChannelOrgEmployee channelOrgEmployee2 = channelOrgEmployees.get(0);
        channelOrgEmployeeEventDto.setChannelOrgCode(channelOrgEmployee2.getChannelOrgCode());
        channelOrgEmployeeEventDto.setChannelOrgName(channelOrgEmployee2.getChannelOrgName());
        channelOrgEmployeeEventDto.setUserCodes(channelOrgEmployees.stream().map(ChannelOrgEmployee::getUserCode).collect(Collectors.toSet()));
        SerializableBiConsumer & Serializable onDelete = ChannelOrgEmployeeEventListener::onDelete;
        this.nebulaNetEventClient.publish((NebulaEventDto)channelOrgEmployeeEventDto, ChannelOrgEmployeeEventListener.class, (SerializableBiConsumer)onDelete);
    }

    @Override
    @Transactional
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ChannelOrgEmployee> channelOrgEmployees = this.channelOrgEmployeeRepository.findEnableStatusByIds(EnableStatusEnum.DISABLE, idList);
        Validate.isTrue((!CollectionUtils.isEmpty(channelOrgEmployees) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u542f\u7528\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        channelOrgEmployees.stream().forEach(channelOrgEmployee -> channelOrgEmployee.setEnableStatus(EnableStatusEnum.ENABLE.getCode()));
        this.channelOrgEmployeeRepository.saveOrUpdateBatch(channelOrgEmployees);
    }

    @Override
    @Transactional
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ChannelOrgEmployee> channelOrgEmployees = this.channelOrgEmployeeRepository.findEnableStatusByIds(EnableStatusEnum.ENABLE, idList);
        Validate.isTrue((!CollectionUtils.isEmpty(channelOrgEmployees) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u7981\u7528\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        channelOrgEmployees.stream().forEach(channelOrgEmployee -> channelOrgEmployee.setEnableStatus(EnableStatusEnum.DISABLE.getCode()));
        this.channelOrgEmployeeRepository.saveOrUpdateBatch(channelOrgEmployees);
    }

    private void createValidate(ChannelOrgEmployee channelOrgEmployee) {
        Validate.notNull((Object)((Object)channelOrgEmployee), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        channelOrgEmployee.setId(null);
        channelOrgEmployee.setTenantCode(TenantUtils.getTenantCode());
        channelOrgEmployee.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        channelOrgEmployee.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        Validate.notBlank((CharSequence)channelOrgEmployee.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)channelOrgEmployee.getChannelOrgCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6e20\u9053\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)channelOrgEmployee.getChannelOrgName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6e20\u9053\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)channelOrgEmployee.getUserCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4f01\u4e1a\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

