package com.biz.crm.mdm.business.channel.org.employee.sdk.event;

import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Set;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 渠道组织员工事件dto
 *
 * @author songjingen
 * @date 2022/11/21 20:30
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ChannelOrgEmployeeEventDto", description = "渠道组织员工事件dto")
public class ChannelOrgEmployeeEventDto implements NebulaEventDto {

  /**
   * 渠道组织编码
   */
  @ApiModelProperty("渠道组织编码")
  private String channelOrgCode;

  /**
   * 渠道组织名称
   */
  @ApiModelProperty("渠道组织名称")
  private String channelOrgName;

  /**
   * 企业用户编码集合
   */
  @ApiModelProperty("企业用户编码集合")
  private Set<String> userCodes;

  /**
   * 员工信息集合
   */
  @ApiModelProperty("员工信息集合")
  private List<ChannelOrgEmployeeInfoEventDto> channelOrgEmployeeInfoEventDtoList;


}
