package com.biz.crm.mdm.business.channel.org.employee.sdk.event;

import com.biz.crm.mdm.business.channel.org.sdk.abstracts.AbstractChannelOrgRelation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 员工信息事件dto
 *
 * @author songjingen
 * @date 2022/11/21 20:30
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "EmployeeInfoEventDto", description = "员工信息事件dto")
public class ChannelOrgEmployeeInfoEventDto extends AbstractChannelOrgRelation {

  /**
   * 用户账号登录信息
   */
  @ApiModelProperty("用户账号登录信息")
  private String userName;

  /**
   * 密码（经过加密的）
   */
  @ApiModelProperty("密码（经过加密的）")
  private String userPassword;

  /**
   * 用户编码
   */
  @ApiModelProperty("用户编码")
  private String userCode;

  /**
   * 人员姓名
   */
  @ApiModelProperty("人员姓名")
  private String fullName;

  /**
   * 电话
   */
  @ApiModelProperty("电话")
  private String userPhone;

  /**
   * 锁定状态 003/009
   */
  @ApiModelProperty("锁定状态 003/009")
  private String lockState;

}
