package com.biz.crm.mdm.business.channel.org.employee.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.channel.org.employee.sdk.dto.ChannelOrgEmployeePaginationDto;
import com.biz.crm.mdm.business.channel.org.sdk.vo.ChannelOrgVo;
import com.biz.crm.workflow.sdk.vo.UserVo;
import com.biz.crm.workflow.sdk.vo.response.UserInfoResponse;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 渠道组织员工voService
 *
 * @author songjingen
 */
public interface ChannelOrgEmployeeVoService {

  /**
   * 根据渠道组织编码查询用户编码
   *
   * @param channelOrgCode
   * @return
   */
  List<String> findUserCodesByChannelOrgCode(String channelOrgCode);

  /**
   *
   * 条件查询
   * @param pageable
   * @param channelOrgEmployeePaginationDto
   * @return
   */
  Page<ChannelOrgVo> findByConditions(Pageable pageable, ChannelOrgEmployeePaginationDto channelOrgEmployeePaginationDto);

  /**
   * 依据tenantCode查询B2b用户信息
   *
   * @param: * @param null
   * @return: * @return: null
   * @author: longhuajiang
   * @date: 2023/1/12
   */
  UserInfoResponse findAllChildrenByOrgCode(List<String> orgCodeList);
}
