package com.biz.crm.mdm.business.channel.org.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.channel.org.feign.feign.internal.ChannelOrgVoFeignImpl;
import com.biz.crm.mdm.business.channel.org.sdk.vo.ChannelOrgVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 渠道组织员工feign
 *
 * @author songjingen
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = ChannelOrgVoFeignImpl.class)
public interface ChannelOrgVoFeign {

  /**
   * 根据渠道组织编码查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   *
   * @param channelOrgCode 渠道组织编码
   */
  @ApiOperation(value = "根据渠道组织编码查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @GetMapping("/v1/channelOrg/channelOrg/findDetailsByChannelOrgCode")
  Result<ChannelOrgVo> findDetailsByChannelOrgCode(@RequestParam("channelOrgCode") @ApiParam("渠道组织编码") String channelOrgCode);

  /**
   * 根据渠道组织编码查询父级渠道组织
   * @param channelOrgCode
   * @return
   */
  @ApiOperation(value = "根据渠道组织编码查询父级渠道组织")
  @GetMapping("/v1/channelOrg/channelOrg/findParentByChannelOrgCode")
  Result<List<ChannelOrgVo>> findParentByChannelOrgCode(@RequestParam("channelOrgCode") @ApiParam("渠道组织编码") String channelOrgCode);

  /**
   * 通过组织编码查询自身及下级渠道组织
   * @param orgCodes
   * @return
   */
  @ApiOperation(value = "通过组织编码查询自身及下级渠道组织")
  @GetMapping("/v1/channelOrg/channelOrg/findCurAndChildrenByOrgCodeList")
  Result<List<ChannelOrgVo>> findCurAndChildrenByOrgCodeList(@RequestParam("orgCodes") @ApiParam("渠道组织编码") List<String> orgCodes);

}
