package com.biz.crm.mdm.business.channel.org.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.channel.org.feign.feign.ChannelOrgVoFeign;
import com.biz.crm.mdm.business.channel.org.sdk.vo.ChannelOrgVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 渠道组织员工feign实现类
 *
 * @author songjingen
 */
@Component
public class ChannelOrgVoFeignImpl implements FallbackFactory<ChannelOrgVoFeign> {

  @Override
  public ChannelOrgVoFeign create(Throwable cause) {
    return new ChannelOrgVoFeign() {

      @Override
      public Result<ChannelOrgVo> findDetailsByChannelOrgCode(String channelOrgCode) {
        throw new UnsupportedOperationException("通过渠道组织编码查询用户编码信息熔断");
      }

      @Override
      public Result<List<ChannelOrgVo>> findParentByChannelOrgCode(String channelOrgCode) {
        throw new UnsupportedOperationException("通过渠道组织编码查询父级渠道信息熔断");
      }

      @Override
      public Result<List<ChannelOrgVo>> findCurAndChildrenByOrgCodeList(List<String> orgCodes) {
        throw new UnsupportedOperationException("通过组织编码查询自身及下级渠道组织信息熔断");
      }
    };
  }
}
