package com.biz.crm.mdm.business.channel.org.local.controller;
/**
 * Created by Bao Hongbin on 2021-10-27 17:48.
 */

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.channel.org.local.service.ChannelOrgPositionVoService;
import com.biz.crm.mdm.business.channel.org.sdk.dto.ChannelOrgPositionBindDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @program: crm
 * @description: 渠道组织职位控制器
 * @author: Bao Hongbin
 * @create: 2021-10-27 17:48
 **/
@Api(tags = "渠道组织：ChannelOrgPositionVo：渠道组织关联职位的相关的内容")
@Slf4j
@RestController
@RequestMapping("/v1/channelOrg/position")
public class ChannelOrgPositionVoController {
  @Autowired(required = false)
  private ChannelOrgPositionVoService channelOrgPositionVoService;


  /**
   * 关联渠道组织和职位
   */
  @ApiOperation(value = "关联渠道组织和职位")
  @PostMapping(value = "/bind")
  public Result<?> bindPosition(
      @RequestBody @ApiParam(name = "channelOrgPositionBindDto",
          value = "关联渠道组织和职位") ChannelOrgPositionBindDto channelOrgPositionBindDto) {
    try {
      this.channelOrgPositionVoService.bindPosition(channelOrgPositionBindDto);
      return Result.ok("关联成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 删除渠道组织和职位关联
   */
  @ApiOperation(value = "删除渠道组织和职位关联")
  @DeleteMapping("/unbind")
  public Result<?> unbindPosition(@RequestParam("ids") List<String> ids) {
    try {
      this.channelOrgPositionVoService.unbindPosition(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
