package com.biz.crm.mdm.business.channel.org.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.channel.org.local.entity.ChannelOrgType;
import com.biz.crm.mdm.business.channel.org.local.service.ChannelOrgTypeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 渠道组织类型表(ChannelOrgType)表相关的http接口
 *
 * @author songjingen
 * @since 2022-11-29 14:35:54
 */
@RestController
@RequestMapping("/v1/channelOrg/channelOrgType")
@Slf4j
@Api(tags = "渠道组织类型表：ChannelOrgType：渠道组织类型表")
public class ChannelOrgTypeController {

  /**
   * 服务对象
   */
  @Autowired
  private ChannelOrgTypeService channelOrgTypeService;

  /**
   * 多条件分页查询
   *
   * @return
   */
  @ApiOperation(value = "多条件分页查询(可适用于列表分页查询和公用分页弹框)", notes = "分页参数为page和size，page从0开始，size默认50;")
  @GetMapping("findByConditions")
  public Result<Page<ChannelOrgType>> findByConditions(@PageableDefault(50) Pageable pageable,
      @ApiParam(name = "channelOrgType", value = "条件") ChannelOrgType channelOrgType) {
    try {
      Page<ChannelOrgType> result = this.channelOrgTypeService.findByConditions(pageable, channelOrgType);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<ChannelOrgType> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      ChannelOrgType channelOrgType = this.channelOrgTypeService.findById(id);
      return Result.ok(channelOrgType);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据渠道组织类型查询数据
   *
   * @param channelOrgTypeCode 渠道组织类型
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("ChannelOrgTypeCode")
  public Result<ChannelOrgType> findByChannelOrgTypeCode(@ApiParam(name = "channelOrgTypeCode", value = "渠道组织类型") String channelOrgTypeCode) {
    try {
      ChannelOrgType channelOrgType = this.channelOrgTypeService.findByChannelOrgTypeCode(channelOrgTypeCode);
      return Result.ok(channelOrgType);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增数据
   *
   * @param channelOrgType 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<ChannelOrgType> create(@ApiParam(name = "channelOrgType", value = "渠道组织类型表") @RequestBody ChannelOrgType channelOrgType) {
    try {
      ChannelOrgType result = this.channelOrgTypeService.create(channelOrgType);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改数据
   *
   * @param channelOrgType 实体对象
   * @return 修改结果
   */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<ChannelOrgType> update(@ApiParam(name = "channelOrgType", value = "渠道组织类型表") @RequestBody ChannelOrgType channelOrgType) {
    try {
      ChannelOrgType result = this.channelOrgTypeService.update(channelOrgType);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除数据（单个或者批量）
   *
   * @param ids 主键集合
   * @return 删除结果
   */
  @DeleteMapping
  @ApiOperation(value = "删除数据（单个或者批量）")
  public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
    try {
      this.channelOrgTypeService.delete(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用（单个或者批量）
   *
   * @param ids 主键结合
   * @return 启用结果
   */
  @PatchMapping("enable")
  @ApiOperation(value = "启用（单个或者批量）")
  public Result<?> enable(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
    try {
      this.channelOrgTypeService.enable(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用（单个或者批量）
   *
   * @param ids 主键结合
   * @return 禁用结果
   */
  @PatchMapping("disable")
  @ApiOperation(value = "禁用（单个或者批量）")
  public Result<?> disable(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
    try {
      this.channelOrgTypeService.disable(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
