package com.biz.crm.mdm.business.channel.org.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Data;
import org.apache.ibatis.type.JdbcType;

/**
 * 渠道组织类型实体类
 */
@Data
@ApiModel(value = "ChannelOrgType", description = "渠道组织类型实体类")
@TableName("mdm_channel_org_type")
@Entity
@Table(name = "mdm_channel_org_type", indexes = {
    @Index(name = "CO_INDEX1", columnList = "channel_org_type_code", unique = true),
})
@org.hibernate.annotations.Table(appliesTo = "mdm_channel_org_type", comment = "渠道组织类型表")
public class ChannelOrgType extends TenantFlagOpEntity {

  private static final long serialVersionUID = -1674819897603635039L;

  /**
   * 渠道组织类型编码
   */
  @ApiModelProperty("渠道组织编码")
  @TableField(value = "channel_org_type_code", jdbcType = JdbcType.VARCHAR)
  @Column(name = "channel_org_type_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '渠道组织编码'")
  private String channelOrgTypeCode;

  /**
   * 渠道组织类型名称
   */
  @ApiModelProperty("渠道组织类型名称")
  @TableField(value = "channel_org_type_name")
  @Column(name = "channel_org_type_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT '渠道组织类型名称'")
  private String channelOrgTypeName;

  /**
   * 渠道组织层级
   */
  @ApiModelProperty("渠道组织层级")
  @TableField(value = "channel_org_level")
  @Column(name = "channel_org_level", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '渠道组织层级'")
  private String channelOrgLevel;

}
