package com.biz.crm.mdm.business.channel.org.local.notifier;
/**
 * Created by Bao Hongbin on 2021-10-12 17:15.
 */

import com.biz.crm.mdm.business.channel.org.sdk.event.ChannelOrgEventListener;
import com.biz.crm.mdm.business.channel.org.sdk.vo.ChannelOrgVo;
import com.bizunited.nebula.common.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @program: crm
 * @description: TODO 推送作日志（目前尚无记录日志功能，该功能将在后续改造中实现，目前无法实现推送，暂时记录为info级系统日志）
 * @author: Bao Hongbin
 **/
@Component
@Slf4j
public class ChannelOrgEventLogListenerImpl implements ChannelOrgEventListener {
  /**
   * 新增渠道组织记录日志
   *
   * @param channelOrgVos
   */
  @Override
  public void onBatchCreate(List<ChannelOrgVo> channelOrgVos) {
    log.info("新增渠道组织信息：{}", JsonUtils.obj2JsonString(channelOrgVos));
  }

  /**
   * 更新渠道组织记录日志
   *
   * @param channelOrgVos
   */
  @Override
  public void onBatchUpdate(List<ChannelOrgVo> channelOrgVos) {
    log.info("更新渠道组织信息：{}", JsonUtils.obj2JsonString(channelOrgVos));
  }

  /**
   * 删除渠道组织记录日志
   *
   * @param channelOrgVos
   */
  @Override
  public void onBatchDelete(List<ChannelOrgVo> channelOrgVos) {
    log.info("删除渠道组织信息：{}", JsonUtils.obj2JsonString(channelOrgVos));
  }

  /**
   * 启用渠道组织记录日志
   *
   * @param channelOrgVos
   */
  @Override
  public void onBatchEnable(List<ChannelOrgVo> channelOrgVos) {
    log.info("启用渠道组织信息：{}", JsonUtils.obj2JsonString(channelOrgVos));
  }

  /**
   * 禁用渠道组织记录日志
   *
   * @param channelOrgVos
   */
  @Override
  public void onBatchDisable(List<ChannelOrgVo> channelOrgVos) {
    log.info("禁用渠道组织信息：{}", JsonUtils.obj2JsonString(channelOrgVos));
  }
}
