package com.biz.crm.mdm.business.channel.org.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.channel.org.local.entity.ChannelOrgType;
import com.biz.crm.mdm.business.channel.org.local.mapper.ChannelOrgTypeMapper;
import com.biz.crm.mdm.business.channel.org.sdk.vo.ChannelOrgVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 渠道组织类型表(ChannelOrgType)表数据库访问层
 *
 * @author songjingen
 * @since 2022-11-29 14:35:54
 */
@Component
public class ChannelOrgTypeRepository extends ServiceImpl<ChannelOrgTypeMapper, ChannelOrgType> {

  /**
   * 根据id集合查询数据
   *
   * @param idList id集合
   * @return
   */
  public List<ChannelOrgType> findByIds(List<String> idList) {
    return this.lambdaQuery().eq(ChannelOrgType::getTenantCode, TenantUtils.getTenantCode())
        .eq(ChannelOrgType::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .in(ChannelOrgType::getId, idList)
        .list();
  }

  /**
   * 根据id集合和启禁用状态查询数据
   *
   * @param statusEnum 启禁用状态
   * @param idList     id集合
   * @return
   */
  public List<ChannelOrgType> findEnableStatusByIds(EnableStatusEnum statusEnum, List<String> idList) {
    return this.lambdaQuery().eq(ChannelOrgType::getTenantCode, TenantUtils.getTenantCode())
        .eq(ChannelOrgType::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(ChannelOrgType::getEnableStatus, statusEnum.getCode())
        .in(ChannelOrgType::getId, idList)
        .list();
  }

  /**
   * 根据渠道组织类型查询数据
   *
   * @param channelOrgTypeCode
   * @return
   */
  public ChannelOrgType findByChannelOrgTypeCode(String channelOrgTypeCode) {
    return this.lambdaQuery().eq(ChannelOrgType::getTenantCode, TenantUtils.getTenantCode())
        .eq(ChannelOrgType::getChannelOrgTypeCode, channelOrgTypeCode)
        .one();
  }

  /**
   * 分页查询
   *
   * @param pageable
   * @param channelOrgType
   * @return
   */
  public Page<ChannelOrgType> findByConditions(Pageable pageable, ChannelOrgType channelOrgType) {
    Page<ChannelOrgVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, channelOrgType);
  }
}

