package com.biz.crm.mdm.business.channel.org.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.channel.org.local.entity.ChannelOrgType;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 渠道组织类型表(ChannelOrgType)表服务接口
 *
 * @author songjingen
 * @since 2022-11-29 14:35:54
 */
public interface ChannelOrgTypeService {

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  ChannelOrgType findById(String id);

  /**
   * 新增数据
   *
   * @param channelOrgType 实体对象
   * @return 新增结果
   */
  ChannelOrgType create(ChannelOrgType channelOrgType);

  /**
   * 修改新据
   *
   * @param channelOrgType 实体对象
   * @return 修改结果
   */
  ChannelOrgType update(ChannelOrgType channelOrgType);

  /**
   * 逻辑删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 启用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 启用结果
   */
  void enable(List<String> idList);

  /**
   * 禁用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 禁用结果
   */
  void disable(List<String> idList);

  /**
   * 根据渠道组织类型查询数据
   *
   * @param channelOrgTypeCode
   * @return
   */
  ChannelOrgType findByChannelOrgTypeCode(String channelOrgTypeCode);

  /**
   * 分页查询
   *
   * @param pageable
   * @param channelOrgType
   * @return
   */
  Page<ChannelOrgType> findByConditions(Pageable pageable, ChannelOrgType channelOrgType);
}

