package com.biz.crm.mdm.business.channel.org.local.service.internal;
/**
 * Created by Bao Hongbin on 2021-11-01 16:47.
 */

import com.biz.crm.mdm.business.channel.org.local.repository.ChannelOrgPositionRepository;
import com.biz.crm.mdm.business.channel.org.local.service.ChannelOrgPositionVoService;
import com.biz.crm.mdm.business.channel.org.local.entity.ChannelOrgPosition;
import com.biz.crm.mdm.business.channel.org.sdk.dto.ChannelOrgPositionBindDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @program: crm
 * @description:
 * @author: Bao Hongbin
 * @create: 2021-11-01 16:47
 **/
@Service
public class ChannelOrgPositionVoServiceImpl implements ChannelOrgPositionVoService {
  @Autowired(required = false)
  private ChannelOrgPositionRepository channelOrgPositionRepository;

  @Override
  @Transactional
  public void unbindPosition(List<String> ids) {
    Validate.isTrue(!CollectionUtils.isEmpty(ids), "当进行解绑操作时，业务技术编号信息必须传入");
    //删除数据
    channelOrgPositionRepository.deleteByIdsAndTenantCode(ids,TenantUtils.getTenantCode());
  }

  @Override
  @Transactional
  public void bindPosition(ChannelOrgPositionBindDto channelOrgPositionBindDto) {
    //1.验证关联参数
    validateRelation(channelOrgPositionBindDto);
    //2.删除旧关联关系
    if (StringUtils.isNotBlank(channelOrgPositionBindDto.getOldChannelOrgCode())) {
      channelOrgPositionRepository.removeRelationByCustomerOrgCodeAndPositionCodes(
          channelOrgPositionBindDto.getOldChannelOrgCode(), channelOrgPositionBindDto.getPositionCodeList(), TenantUtils.getTenantCode());
    }
    //3.设置新关联关系
    List<ChannelOrgPosition> channelOrgPositions =
        channelOrgPositionBindDto.getPositionCodeList().stream().map(positionCode -> {
          ChannelOrgPosition channelOrgPosition = new ChannelOrgPosition();
          channelOrgPosition.setTenantCode(TenantUtils.getTenantCode());
          channelOrgPosition.setPositionCode(positionCode);
          channelOrgPosition.setChannelOrgCode(channelOrgPositionBindDto.getChannelOrgCode());
          return channelOrgPosition;
        }).collect(Collectors.toList());
    channelOrgPositionRepository.saveOrUpdateBatch(channelOrgPositions);

  }

  @Override
  public List<ChannelOrgPosition> findByCustomerOrgCodes(List<String> customerOrgCodes) {
    if (CollectionUtils.isEmpty(customerOrgCodes)) {
      return null;
    }
    return channelOrgPositionRepository.findListByCustomerOrgCodes(customerOrgCodes, TenantUtils.getTenantCode());
  }

  private void validateRelation(ChannelOrgPositionBindDto channelOrgPositionBindDto) {
    Validate.notEmpty(channelOrgPositionBindDto.getChannelOrgCode(), "渠道组织编码必须传入！");
    Validate.isTrue(!CollectionUtils.isEmpty(channelOrgPositionBindDto.getPositionCodeList()),
        "需要关联的职位编码不能为空！");
  }
}
