package com.biz.crm.mdm.business.channel.org.local.service.internal;
/**
 * Created by Bao Hongbin on 2021-10-28 18:07.
 */

import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.business.common.sdk.utils.TreeUtil;
import com.biz.crm.business.common.sdk.vo.TreeVo;
import com.biz.crm.mdm.business.channel.org.local.entity.ChannelOrg;
import com.biz.crm.mdm.business.channel.org.local.repository.ChannelOrgRepository;
import com.biz.crm.mdm.business.channel.org.local.service.ChannelOrgTreeVoService;
import com.biz.crm.mdm.business.channel.org.sdk.constant.ChannelOrgConstant;
import com.biz.crm.mdm.business.channel.org.sdk.dto.ChannelOrgTreeDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @program: crm
 * @description: 渠道组织载树服务实现
 * @author: Bao Hongbin
 * @create: 2021-10-28 18:07
 **/
@Service
public class ChannelOrgTreeVoServiceImpl implements ChannelOrgTreeVoService {

  @Autowired(required = false)
  private ChannelOrgRepository channelOrgRepository;
  @Autowired(required = false)
  private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;


  @Override
  public List<TreeVo> findTree(ChannelOrgTreeDto treeDto) {
    treeDto = Optional.ofNullable(treeDto).orElse(new ChannelOrgTreeDto());
    List<TreeVo> tree = new ArrayList<>();
    List<ChannelOrg> list = new ArrayList<>();
    if (StringUtils.isBlank(treeDto.getChannelOrgLevel())) {
      list = channelOrgRepository.findListLikeName(treeDto.getEnableStatus(), treeDto.getName(), TenantUtils.getTenantCode());
    } else {
      list = channelOrgRepository.findListLikeNameAndChannelOrgLevel(treeDto.getEnableStatus(), treeDto.getName(), TenantUtils.getTenantCode(), treeDto.getChannelOrgLevel());
    }
    if (CollectionUtils.isEmpty(list)) {
      return tree;
    }
    if (StringUtils.isNotEmpty(treeDto.getName())) {
      //查询所有符合的
      TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
      Set<String> set = treeRuleCodeStrategy.findParentRuleCodeByRuleCodes(
          ChannelOrgConstant.RULE_CODE_LENGTH, list.stream().map(ChannelOrg::getRuleCode).collect(Collectors.toList()));
      if (!CollectionUtils.isEmpty(set)) {
        List<List<String>> partition = Lists.partition(new ArrayList<>(set), 500);
        list = new ArrayList<>();
        for (List<String> part : partition) {
          list.addAll(channelOrgRepository.findListByRuleCodes(new HashSet<>(part), TenantUtils.getTenantCode()));
        }
      }
    }
    List<TreeVo> collect = list.stream().map(x -> {
      TreeVo treeVo = new TreeVo();
      treeVo.setId(x.getId());
      treeVo.setParentCode(x.getParentCode());
      treeVo.setCode(x.getChannelOrgCode());
      treeVo.setName(x.getChannelOrgName());
      return treeVo;
    }).collect(Collectors.toList());
    tree = TreeUtil.generateTreeByParentCode(collect);
    if (StringUtils.isNotEmpty(treeDto.getExcludeCodeAndChildren())) {
      TreeUtil.excludeCodeAndChildren(tree, treeDto.getExcludeCodeAndChildren());
    }
    return tree;
  }


}
