package com.biz.crm.mdm.business.channel.org.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.channel.org.local.entity.ChannelOrgType;
import com.biz.crm.mdm.business.channel.org.local.repository.ChannelOrgTypeRepository;
import com.biz.crm.mdm.business.channel.org.local.service.ChannelOrgTypeService;
import com.biz.crm.mdm.business.channel.org.sdk.constant.ChannelOrgConstant;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 渠道组织类型表(ChannelOrgType)表服务实现类
 *
 * @author songjingen
 * @since 2022-11-29 14:35:54
 */
@Service("channelOrgTypeService")
public class ChannelOrgTypeServiceImpl implements ChannelOrgTypeService {

  @Autowired
  private ChannelOrgTypeRepository channelOrgTypeRepository;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public ChannelOrgType findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return this.channelOrgTypeRepository.getById(id);
  }

  /**
   * 新增数据
   *
   * @param channelOrgType 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public ChannelOrgType create(ChannelOrgType channelOrgType) {
    this.createValidate(channelOrgType);
    this.channelOrgTypeRepository.saveOrUpdate(channelOrgType);
    return channelOrgType;
  }

  /**
   * 修改新据
   *
   * @param channelOrgType 实体对象
   * @return 修改结果
   */
  @Transactional
  @Override
  public ChannelOrgType update(ChannelOrgType channelOrgType) {
    ChannelOrgType current = this.channelOrgTypeRepository.getById(channelOrgType);
    Validate.notNull(current, "未查询到要修改的数据！");
    BeanUtils.copyProperties(channelOrgType, current, "id", "channelOrgTypeCode", "tenantCode", "createAccount", "delFlag", "enableStatus", "createName", "createTime");
    this.updateValidate(current);
    this.channelOrgTypeRepository.saveOrUpdate(current);
    return current;
  }

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @Transactional
  @Override
  public void delete(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
    List<ChannelOrgType> channelOrgTypes = this.channelOrgTypeRepository.findByIds(idList);
    Validate.isTrue(!CollectionUtils.isEmpty(channelOrgTypes), "删除数据时，未查询到需要删除的数据！");
    channelOrgTypes.stream().forEach(channelOrgType -> channelOrgType.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
    this.channelOrgTypeRepository.saveOrUpdateBatch(channelOrgTypes);
  }

  /**
   * 启用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 启用结果
   */
  @Transactional
  @Override
  public void enable(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "启用数据时，主键集合不能为空！");
    List<ChannelOrgType> channelOrgTypes = this.channelOrgTypeRepository.findEnableStatusByIds(EnableStatusEnum.DISABLE, idList);
    Validate.isTrue(!CollectionUtils.isEmpty(channelOrgTypes), "启用数据时，未查询到需要启用的数据！");
    channelOrgTypes.stream().forEach(channelOrgType -> channelOrgType.setEnableStatus(EnableStatusEnum.ENABLE.getCode()));
    this.channelOrgTypeRepository.saveOrUpdateBatch(channelOrgTypes);
  }

  /**
   * 禁用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 禁用结果
   */
  @Transactional
  @Override
  public void disable(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "禁用数据时，主键集合不能为空！");
    List<ChannelOrgType> channelOrgTypes = this.channelOrgTypeRepository.findEnableStatusByIds(EnableStatusEnum.ENABLE, idList);
    Validate.isTrue(!CollectionUtils.isEmpty(channelOrgTypes), "禁用数据时，未查询到需要禁用的数据！");
    channelOrgTypes.stream().forEach(channelOrgType -> channelOrgType.setEnableStatus(EnableStatusEnum.DISABLE.getCode()));
    this.channelOrgTypeRepository.saveOrUpdateBatch(channelOrgTypes);
  }

  @Override
  public ChannelOrgType findByChannelOrgTypeCode(String channelOrgTypeCode) {
    if (StringUtils.isBlank(channelOrgTypeCode)) {
      return null;
    }
    return this.channelOrgTypeRepository.findByChannelOrgTypeCode(channelOrgTypeCode);
  }

  @Override
  public Page<ChannelOrgType> findByConditions(Pageable pageable, ChannelOrgType channelOrgType) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    if (channelOrgType == null) {
      channelOrgType = new ChannelOrgType();
    }
    return this.channelOrgTypeRepository.findByConditions(pageable, channelOrgType);
  }

  /**
   * 创建验证
   *
   * @param channelOrgType
   */
  private void createValidate(ChannelOrgType channelOrgType) {
    Validate.notNull(channelOrgType, "新增时，对象信息不能为空！");
    channelOrgType.setId(null);
    channelOrgType.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    channelOrgType.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    channelOrgType.setTenantCode(TenantUtils.getTenantCode());
    channelOrgType.setChannelOrgTypeCode(this.generateCodeService.generateCode(ChannelOrgConstant.CHANNEL_ORY_TYPE_CODE, 1).get(0));
    Validate.notBlank(channelOrgType.getTenantCode(), "新增数据时，租户编号不能为空！");
    Validate.notBlank(channelOrgType.getChannelOrgLevel(), "新增数据时，渠道组织层级不能为空！");
    Validate.notBlank(channelOrgType.getChannelOrgTypeCode(), "新增数据时，渠道组织编码不能为空！");
    Validate.notBlank(channelOrgType.getChannelOrgTypeName(), "新增数据时，渠道组织类型名称不能为空！");

  }

  /**
   * 修改验证
   *
   * @param channelOrgType
   */
  private void updateValidate(ChannelOrgType channelOrgType) {
    Validate.notNull(channelOrgType, "修改时，对象信息不能为空！");
    Validate.notBlank(channelOrgType.getId(), "修改数据时，不能为空！");
    Validate.notBlank(channelOrgType.getTenantCode(), "修改数据时，租户编号不能为空！");
    Validate.notBlank(channelOrgType.getChannelOrgLevel(), "修改数据时，渠道组织层级不能为空！");
    Validate.notBlank(channelOrgType.getChannelOrgTypeCode(), "修改数据时，渠道组织编码不能为空！");
    Validate.notBlank(channelOrgType.getChannelOrgTypeName(), "修改数据时，渠道组织类型名称不能为空！");

  }
}

