package com.biz.crm.mdm.business.channel.org.local.service.internal;
/**
 * Created by Bao Hongbin on 2021-10-27 18:00.
 */

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.mdm.business.channel.org.local.entity.ChannelOrg;
import com.biz.crm.mdm.business.channel.org.local.repository.ChannelOrgRepository;
import com.biz.crm.mdm.business.channel.org.local.service.helper.ChannelOrgServiceHelper;
import com.biz.crm.mdm.business.channel.org.sdk.constant.ChannelOrgConstant;
import com.biz.crm.mdm.business.channel.org.sdk.dto.*;
import com.biz.crm.mdm.business.channel.org.sdk.event.ChannelOrgNebulaEventListener;
import com.biz.crm.mdm.business.channel.org.sdk.service.ChannelOrgVoService;
import com.biz.crm.mdm.business.channel.org.sdk.strategy.ChannelOrgRelationStrategy;
import com.biz.crm.mdm.business.channel.org.sdk.vo.ChannelOrgVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @program: crm
 * @description: 渠道组织服务实现
 * @author: Bao Hongbin
 * @create: 2021-10-27 18:00
 **/
@Service
@Slf4j
public class ChannelOrgVoServiceImpl implements ChannelOrgVoService {

  @Autowired(required = false)
  private ChannelOrgRepository channelOrgRepository;
  @Autowired(required = false)
  private ChannelOrgServiceHelper helper;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private GenerateCodeService generateCode;
  @Autowired(required = false)
  private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;
  @Autowired(required = false)
  private NebulaNetEventClient nebulaNetEventClient;
  @Autowired(required = false)
  private List<ChannelOrgRelationStrategy> channelOrgRelationStrategies;

  @Override
  public Page<ChannelOrgVo> findByConditions(Pageable pageable, ChannelOrgPaginationDto channelOrgPaginationDto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    channelOrgPaginationDto = Optional.ofNullable(channelOrgPaginationDto).orElse(new ChannelOrgPaginationDto());
    channelOrgPaginationDto.setTenantCode(TenantUtils.getTenantCode());
    //白名单ruleCode
    if (StringUtils.isNotEmpty(channelOrgPaginationDto.getUnderChannelOrgCode())) {
      //如果条件成立，说明本次查询只查询该白名单里的数据及其子集
      ChannelOrg one = channelOrgRepository.findDetailsByCode(
          channelOrgPaginationDto.getUnderChannelOrgCode(),
          channelOrgPaginationDto.getTenantCode());
      if (one != null) {
        channelOrgPaginationDto.setUnderThisRuleCode(one.getRuleCode());
      }
    }
    //黑名单ruleCode
    if (StringUtils.isNotEmpty(channelOrgPaginationDto.getNotUnderChannelOrgCode())) {
      //如果条件成立，说明本次查询不查询该黑名单里的数据及其子集
      ChannelOrg one = channelOrgRepository.findDetailsByCode(
          channelOrgPaginationDto.getNotUnderChannelOrgCode(),
          channelOrgPaginationDto.getTenantCode());
      if (one != null) {
        channelOrgPaginationDto.setNotUnderThisRuleCode(one.getRuleCode());
      }
    }
    //设置已选择项（如果查询条件符合，那么已选择项需要优先显示）
    List<String> selectedCodeList =
        Optional.ofNullable(channelOrgPaginationDto.getSelectedCodeList()).orElse(new ArrayList<>());
    if (StringUtils.isNotEmpty(channelOrgPaginationDto.getSelectedCode())) {
      selectedCodeList.add(channelOrgPaginationDto.getSelectedCode());
    }
    if (!CollectionUtils.isEmpty(selectedCodeList)) {
      channelOrgPaginationDto.setSelectedCodeList(selectedCodeList);
    }
    return channelOrgRepository.findByConditions(pageable, channelOrgPaginationDto);
  }

  @Override
  public ChannelOrgVo findDetailsById(String id) {
    if (!StringUtils.isNotEmpty(id)) {
      return null;
    }
    ChannelOrg one = channelOrgRepository.findDetailsById(id, TenantUtils.getTenantCode());
    if (one == null) {
      return null;
    }
    ChannelOrgVo respVo = nebulaToolkitService.copyObjectByWhiteList(
        one, ChannelOrgVo.class, HashSet.class, ArrayList.class);
    if (StringUtils.isNotEmpty(one.getParentCode())) {
      ChannelOrg parent = channelOrgRepository.findDetailsByCode(one.getParentCode(), TenantUtils.getTenantCode());
      if (parent != null) {
        respVo.setParentName(parent.getChannelOrgName());
      }
    }
    return respVo;
  }

  @Override
  @Transactional
  public ChannelOrgVo create(ChannelOrgCreateDto channelOrgCreateDto) {
    return this.createForm(channelOrgCreateDto);
  }

  private ChannelOrgVo createForm(ChannelOrgCreateDto channelOrgCreateDto) {
    //1.数据验证
    helper.createValidation(channelOrgCreateDto);
    if (StringUtils.isBlank(channelOrgCreateDto.getParentCode())) {
      //前端传空字符串时，将其设为null
      channelOrgCreateDto.setParentCode(null);
    }
    ChannelOrg channelOrg = this.nebulaToolkitService.copyObjectByWhiteList(
        channelOrgCreateDto, ChannelOrg.class, HashSet.class, ArrayList.class);
    channelOrg.setTenantCode(TenantUtils.getTenantCode());
    channelOrg.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    channelOrg.setEnableStatus(null != channelOrg.getEnableStatus() ? channelOrg.getEnableStatus() : EnableStatusEnum.ENABLE.getCode());
    //2.判断渠道组织编码是否为空，如果不为空那么查询是否存在，如果为空则设置
    if (StringUtils.isBlank(channelOrgCreateDto.getChannelOrgCode())) {
      //TODO 各业务编码前缀以前可以在系统设置中进行设置，该功能将在后续改造中实现，先设置为固定默认值
      channelOrg.setChannelOrgCode(generateCode.generateCode(ChannelOrgConstant.CODE, 1).get(0));
    }
    //3.根据父级设置层级
    int levelNum = 1;
    if (StringUtils.isNotEmpty(channelOrgCreateDto.getParentCode())) {
      ChannelOrg parent = channelOrgRepository.findDetailsByCode(channelOrgCreateDto.getParentCode(), TenantUtils.getTenantCode());
      levelNum = parent.getLevelNum() + 1;
    }
    //4.设置规则（降维）编码
    String ruleCode = getRuleCodeByParentCode(channelOrgCreateDto.getParentCode());
    channelOrg.setRuleCode(ruleCode);
    channelOrg.setLevelNum(levelNum);
    //5.保存数据
    channelOrgRepository.save(channelOrg);
    //6.推送onCreate事件
    ChannelOrgVo channelOrgVo = nebulaToolkitService.copyObjectByWhiteList(
        channelOrg, ChannelOrgVo.class, HashSet.class, ArrayList.class);
    helper.sendCreateEvent(Collections.singletonList(channelOrgVo));

    //通过事件引擎发送事件通知
    ChannelOrgEventDto channelOrgEventDto = this.nebulaToolkitService.copyObjectByWhiteList(channelOrg, ChannelOrgEventDto.class, HashSet.class, ArrayList.class);
    SerializableBiConsumer<ChannelOrgNebulaEventListener, ChannelOrgEventDto> nebulaEvent = ChannelOrgNebulaEventListener::onCreate;
    this.nebulaNetEventClient.publish(channelOrgEventDto, ChannelOrgNebulaEventListener.class, nebulaEvent);
    return channelOrgVo;
  }

  private String getRuleCodeByParentCode(String parentCode) {
    String parentRuleCode = null;
    if (StringUtils.isNotEmpty(parentCode)) {
      ChannelOrg parent = channelOrgRepository.findDetailsByCode(parentCode, TenantUtils.getTenantCode());
      Validate.notNull(parent, "上级渠道组织不存在");
      parentRuleCode = parent.getRuleCode();
    }
    List<ChannelOrg> childrenListByParentCode =
        channelOrgRepository.findChildrenListByParentCode(parentCode, TenantUtils.getTenantCode());
    List<TreeDto> childrenDto =
        Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(childrenListByParentCode, ChannelOrg.class
            , TreeDto.class, HashSet.class, ArrayList.class));
    //TODO 编码降维编码长度以前可以在系统设置中进行设置，该功能将在后续改造中实现，先设置为固定默认值
    TreeRuleCodeStrategy treeRuleCodeStrategy = treeRuleCodeStrategyHolder.getStrategy(null);
    return treeRuleCodeStrategy.generate(
        ChannelOrgConstant.RULE_CODE_LENGTH, parentRuleCode, childrenDto);
  }

  @Override
  @Transactional
  public ChannelOrgVo update(ChannelOrgUpdateDto channelOrgUpdateDto) {
    return this.updateForm(channelOrgUpdateDto);
  }

  private ChannelOrgVo updateForm(ChannelOrgUpdateDto channelOrgUpdateDto) {
    //1.数据验证
    helper.updateValidation(channelOrgUpdateDto);
    if (StringUtils.isBlank(channelOrgUpdateDto.getParentCode())) {
      //前端传空字符串时，将其设为null
      channelOrgUpdateDto.setParentCode(null);
    }
    ChannelOrg channelOrg =
        channelOrgRepository.findDetailsById(channelOrgUpdateDto.getId(), TenantUtils.getTenantCode());
    //2.根据父级设置层级
    int levelNum = 1;
    if (StringUtils.isNotEmpty(channelOrgUpdateDto.getParentCode())) {
      ChannelOrg parent = channelOrgRepository.findDetailsByCode(channelOrgUpdateDto.getParentCode(), TenantUtils.getTenantCode());
      levelNum = parent.getLevelNum() + 1;
    }
    //旧数据转换
    ChannelOrgEventDto oldChannelOrgEventDto = this.nebulaToolkitService.copyObjectByWhiteList(channelOrg, ChannelOrgEventDto.class, HashSet.class, ArrayList.class);
    //3.更新数据
    ChannelOrg channelOrgNew = this.nebulaToolkitService.copyObjectByWhiteList(
        channelOrgUpdateDto, ChannelOrg.class, HashSet.class, ArrayList.class);
    //重构修改方法
    channelOrgRepository.updateById(channelOrgNew);
    if (StringUtils.isBlank(channelOrgUpdateDto.getParentCode())) {
      //如果ParentCode为空，则手动设置为空
      channelOrgRepository.setParentCodeNull(channelOrgUpdateDto.getId());
    }
    //4.判断是否需要重置降维编码和更新启用状态
    boolean updateRuleCode = false;
    String enableStatusChangeTo = "";
    if (!(channelOrg.getParentCode() == null ? "" : channelOrg.getParentCode())
        .equals((channelOrgUpdateDto.getParentCode() == null ? "" : channelOrgUpdateDto.getParentCode()))) {
      //上级编码发生变化，重置降维编码
      updateRuleCode = true;
    }
    if (!(channelOrg.getEnableStatus()).equals(channelOrgUpdateDto.getEnableStatus())) {
      //启用状态发生变化
      enableStatusChangeTo = channelOrgUpdateDto.getEnableStatus();
    }
    if (updateRuleCode) {
      //4.1更新降维编码
      String ruleCode = getRuleCodeByParentCode(channelOrgUpdateDto.getParentCode());
      updateCurAndChildrenRuleCode(channelOrgNew.getChannelOrgCode(), ruleCode, levelNum);
    }
    if (StringUtils.isNotEmpty(enableStatusChangeTo)) {
      //4.2更新启用禁用状态
      if (EnableStatusEnum.ENABLE.getCode().equals(enableStatusChangeTo)) {
        this.enableBatch(Collections.singletonList(channelOrgNew.getId()));
      } else if (EnableStatusEnum.DISABLE.getCode().equals(enableStatusChangeTo)) {
        this.disableBatch(Collections.singletonList(channelOrgNew.getId()));
      } else {
        throw new IllegalArgumentException("启用状态错误");
      }
    }
    //6.推送onUpdate事件
    //再次查询更新后的数据
    channelOrg = channelOrgRepository.findDetailsById(channelOrgUpdateDto.getId(), TenantUtils.getTenantCode());
    ChannelOrgVo channelOrgVo = nebulaToolkitService.copyObjectByWhiteList(
        channelOrg, ChannelOrgVo.class, HashSet.class, ArrayList.class);
    helper.sendUpdateEvent(Collections.singletonList(channelOrgVo));
    //通过事件引擎发送事件通知
    ChannelOrgEventDto newChannelOrgEventDto = this.nebulaToolkitService.copyObjectByWhiteList(channelOrgUpdateDto, ChannelOrgEventDto.class, HashSet.class, ArrayList.class);
    ChannelOrgEventUpdateDto channelOrgEventUpdateDto = new ChannelOrgEventUpdateDto();
    channelOrgEventUpdateDto.setOldChannelOrgEventDto(oldChannelOrgEventDto);
    channelOrgEventUpdateDto.setNewChannelOrgEventDto(newChannelOrgEventDto);
    SerializableBiConsumer<ChannelOrgNebulaEventListener, ChannelOrgEventUpdateDto> nebulaEvent = ChannelOrgNebulaEventListener::onUpdate;
    this.nebulaNetEventClient.publish(channelOrgEventUpdateDto, ChannelOrgNebulaEventListener.class, nebulaEvent);
    return channelOrgVo;
  }

  /**
   * 更新自己及子集的降维编码
   *
   * @param customerOrgCode
   * @param ruleCode
   * @param levelNum
   */
  private void updateCurAndChildrenRuleCode(String customerOrgCode, String ruleCode, int levelNum) {
    //更新当前
    ChannelOrg channelOrg = channelOrgRepository.findDetailsByCode(customerOrgCode, TenantUtils.getTenantCode());
    Validate.notNull(channelOrg, customerOrgCode + "不存在或已删除！");
    channelOrg.setRuleCode(ruleCode);
    channelOrg.setLevelNum(levelNum);
    this.channelOrgRepository.updateById(channelOrg);
    //查询下一层
    List<ChannelOrg> childrenList = channelOrgRepository.findChildrenListByParentCode(customerOrgCode, TenantUtils.getTenantCode());
    if (CollectionUtils.isEmpty(childrenList)) {
      return;
    }
    //遍历下级
    TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
    for (int i = 0; i < childrenList.size(); i++) {
      //递归调用
      updateCurAndChildrenRuleCode(childrenList.get(i).getChannelOrgCode(),
          ruleCode + treeRuleCodeStrategy.generateByNum(ChannelOrgConstant.RULE_CODE_LENGTH, i + 1),
          levelNum + 1);
    }
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    Validate.isTrue(!CollectionUtils.isEmpty(ids), "当进行启用操作时，业务技术编号信息必须传入");
    //1.获取需要启用的数据
    List<ChannelOrg> channelOrgList =
        channelOrgRepository.findListByIds(ids, TenantUtils.getTenantCode())
            .stream().filter(x -> !EnableStatusEnum.ENABLE.getCode().equals(x.getEnableStatus()))
            .collect(Collectors.toList());
    if (CollectionUtils.isEmpty(channelOrgList)) {
      return;
    }
    //2.根据ruleCode获取其所有的上级
    List<String> collect = channelOrgList.stream().map(ChannelOrg::getRuleCode).collect(Collectors.toList());
    TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
    Set<String> parentRuleCodesExcludeSelf =
        treeRuleCodeStrategy.findParentRuleCodeByRuleCodesExcludeAnySelf(
            ChannelOrgConstant.RULE_CODE_LENGTH, collect);
    if (!parentRuleCodesExcludeSelf.isEmpty()) {
      //3.如果存在未启用的上级层级，不能启用当前层级
      List<ChannelOrg> parentList = channelOrgRepository.findListByRuleCodes(parentRuleCodesExcludeSelf, TenantUtils.getTenantCode())
          .stream()
          .filter(customerOrg -> !EnableStatusEnum.ENABLE.getCode().equals(customerOrg.getEnableStatus()) && !ids.contains(customerOrg.getId()))
          .collect(Collectors.toList());
      Validate.isTrue(CollectionUtils.isEmpty(parentList), "存在未启用的上级层级，不能启用当前层级");
    }
    //4.更新启用状态
    channelOrgList.forEach(customerOrg -> customerOrg.setEnableStatus(EnableStatusEnum.ENABLE.getCode()));
    //启用
    this.channelOrgRepository.updateEnableStatusByIds(channelOrgList.stream().map(ChannelOrg::getId).collect(Collectors.toList()), EnableStatusEnum.ENABLE);
    //5.推送onEnable事件
    ArrayList<ChannelOrgVo> channelOrgVos =
        Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(channelOrgList, ChannelOrg.class
            , ChannelOrgVo.class, HashSet.class, ArrayList.class));
    helper.sendEnableEvent(channelOrgVos);

    //通过事件引擎发送事件通知
    List<ChannelOrgEventDto> channelOrgEventDtoList = Lists.newArrayList(
        this.nebulaToolkitService.copyCollectionByWhiteList(channelOrgList, ChannelOrg.class, ChannelOrgEventDto.class, HashSet.class, ArrayList.class));
    ChannelOrgEventBatchDto channelOrgEventBatchDto = new ChannelOrgEventBatchDto();
    channelOrgEventBatchDto.setChannelOrgEventDtoList(channelOrgEventDtoList);
    SerializableBiConsumer<ChannelOrgNebulaEventListener, ChannelOrgEventBatchDto> nebulaEvent = ChannelOrgNebulaEventListener::onEnableBatch;
    this.nebulaNetEventClient.publish(channelOrgEventBatchDto, ChannelOrgNebulaEventListener.class, nebulaEvent);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    Validate.isTrue(!CollectionUtils.isEmpty(ids), "当进行禁用操作时，业务技术编号信息必须传入");
    //1.获取需要禁用的数据
    List<ChannelOrg> channelOrgList = channelOrgRepository.findListByIds(ids, TenantUtils.getTenantCode());
    if (CollectionUtils.isEmpty(channelOrgList)) {
      return;
    }
    //2.使用ruleCode模糊查询所有需要禁用的数据
    List<String> ruleCodes = channelOrgList.stream().map(ChannelOrg::getRuleCode).collect(Collectors.toList());
    List<ChannelOrg> childrenByRuleCodeList =
        channelOrgRepository.findCurAndChildrenByRuleCodeList(ruleCodes, EnableStatusEnum.ENABLE.getCode(), TenantUtils.getTenantCode());
    if (!CollectionUtils.isEmpty(childrenByRuleCodeList)) {
      //3.更新启用状态
      childrenByRuleCodeList.forEach(customerOrg -> customerOrg.setEnableStatus(EnableStatusEnum.DISABLE.getCode()));
      //禁用
      this.channelOrgRepository.updateEnableStatusByIds(childrenByRuleCodeList.stream().map(ChannelOrg::getId).collect(Collectors.toList()), EnableStatusEnum.DISABLE);
      //4.推送onDisable事件
      ArrayList<ChannelOrgVo> channelOrgVos =
          Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(childrenByRuleCodeList, ChannelOrg.class
              , ChannelOrgVo.class, HashSet.class, ArrayList.class));
      helper.sendDisableEvent(channelOrgVos);
      //通过事件引擎发送事件通知
      List<ChannelOrgEventDto> channelOrgEventDtoList = Lists.newArrayList(
          this.nebulaToolkitService.copyCollectionByWhiteList(channelOrgList, ChannelOrg.class, ChannelOrgEventDto.class, HashSet.class, ArrayList.class));
      ChannelOrgEventBatchDto channelOrgEventBatchDto = new ChannelOrgEventBatchDto();
      channelOrgEventBatchDto.setChannelOrgEventDtoList(channelOrgEventDtoList);
      SerializableBiConsumer<ChannelOrgNebulaEventListener, ChannelOrgEventBatchDto> nebulaEvent = ChannelOrgNebulaEventListener::onDisableBatch;
      this.nebulaNetEventClient.publish(channelOrgEventBatchDto, ChannelOrgNebulaEventListener.class, nebulaEvent);
    }
  }

  @Override
  @Transactional
  public void deleteBatch(List<String> ids) {
    Validate.isTrue(!CollectionUtils.isEmpty(ids), "当进行删除操作时，业务技术编号信息必须传入");
    //1.获取需要删除的数据
    List<ChannelOrg> channelOrgs = channelOrgRepository.findListByIds(ids, TenantUtils.getTenantCode());
    Validate.isTrue(!CollectionUtils.isEmpty(channelOrgs), "无效的业务技术编号信息");
    List<String> customerOrgCodeList =
        channelOrgs.stream().map(ChannelOrg::getChannelOrgCode).collect(Collectors.toList());
    //2.判断是否存在子层级
    List<ChannelOrg> childrenList =
        channelOrgRepository.findChildrenListByParentCodes(customerOrgCodeList, TenantUtils.getTenantCode())
            .stream().filter(o -> !ids.contains(o.getId())).collect(Collectors.toList());
    Validate.isTrue(CollectionUtils.isEmpty(childrenList), "当前渠道组织包含子层级，无法删除，若需要删除请先删除子层级");
    //3.逻辑删除渠道组织
    for (ChannelOrg channelOrg : channelOrgs) {
      channelOrg.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
    }
    //逻辑删除
    this.channelOrgRepository.updateDelFlagByIds(channelOrgs.stream().map(ChannelOrg::getId).collect(Collectors.toList()));
    //如果ParentCode为空，则手动设置为空
    for (ChannelOrg channelOrg : channelOrgs) {
      channelOrgRepository.setParentCodeAndRuleCodeNull(channelOrg.getId());
    }
    //4.推送onDelete事件
    ArrayList<ChannelOrgVo> channelOrgVos =
        Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(channelOrgs, ChannelOrg.class
            , ChannelOrgVo.class, HashSet.class, ArrayList.class));
    helper.sendDeleteEvent(channelOrgVos);

    //通过事件引擎发送事件通知
    List<ChannelOrgEventDto> channelOrgEventDtoList = Lists.newArrayList(
        this.nebulaToolkitService.copyCollectionByWhiteList(channelOrgs, ChannelOrg.class, ChannelOrgEventDto.class, HashSet.class, ArrayList.class));
    ChannelOrgEventBatchDto channelOrgEventBatchDto = new ChannelOrgEventBatchDto();
    channelOrgEventBatchDto.setChannelOrgEventDtoList(channelOrgEventDtoList);
    SerializableBiConsumer<ChannelOrgNebulaEventListener, ChannelOrgEventBatchDto> nebulaEvent = ChannelOrgNebulaEventListener::onDeleteBatch;
    this.nebulaNetEventClient.publish(channelOrgEventBatchDto, ChannelOrgNebulaEventListener.class, nebulaEvent);
  }

  @Override
  @Transactional
  public void updateRuleCode() {
    //1.查找parentCode不为空但找不到对应上级的数据，将其parentCode设为空
    channelOrgRepository.updateOrphanParentCodeNull(TenantUtils.getTenantCode());
    //2.查找所有parentCode为空的数据（相当于第一层数据）
    List<ChannelOrg> topList =
        channelOrgRepository.findListWithoutParentCode(TenantUtils.getTenantCode());
    //3.递归设置其ruleCode和其所有子级的ruleCode
    TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
    for (int i = 0; i < topList.size(); i++) {
      //递归调用
      updateCurAndChildrenRuleCode(topList.get(i).getChannelOrgCode(),
          treeRuleCodeStrategy.generateByNum(ChannelOrgConstant.RULE_CODE_LENGTH, i + 1),
          1);
    }
  }

  @Override
  public List<ChannelOrgVo> findAll() {
    List<ChannelOrg> all = channelOrgRepository.findAll(TenantUtils.getTenantCode());
    return Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(all, ChannelOrg.class, ChannelOrgVo.class, HashSet.class, ArrayList.class));
  }

  @Override
  public List<ChannelOrgVo> findCurAndChildrenByOrgCodeList(List<String> orgCodes) {
    if (CollectionUtils.isEmpty(orgCodes)) {
      return new ArrayList<>();
    }
    List<ChannelOrg> channelOrgs = channelOrgRepository
        .findCurAndChildrenByOrgCodeList(orgCodes, EnableStatusEnum.ENABLE.getCode(), TenantUtils.getTenantCode());
    if (CollectionUtils.isEmpty(channelOrgs)) {
      return new ArrayList<>();
    }
    return Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(channelOrgs, ChannelOrg.class, ChannelOrgVo.class, HashSet.class, ArrayList.class));
  }

  @Override
  public List<ChannelOrgVo> findByChannelOrgCodes(List<String> channelOrgCodes) {
    if (CollectionUtils.isEmpty(channelOrgCodes)) {
      return new ArrayList<>();
    }
    List<ChannelOrg> entities = this.channelOrgRepository.findByCustomerOrgCodes(channelOrgCodes);
    if (CollectionUtils.isEmpty(entities)) {
      return new ArrayList<>();
    }
    return Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(entities, ChannelOrg.class, ChannelOrgVo.class, HashSet.class, ArrayList.class));
  }

  @Override
  public ChannelOrgVo findDetailsByChannelOrgCode(String channelOrgCode) {
    if (!StringUtils.isNotEmpty(channelOrgCode)) {
      return null;
    }
    ChannelOrg one = channelOrgRepository.findDetailsByCode(channelOrgCode, TenantUtils.getTenantCode());
    if (one == null) {
      return null;
    }
    ChannelOrgVo respVo = nebulaToolkitService.copyObjectByWhiteList(
        one, ChannelOrgVo.class, HashSet.class, ArrayList.class);
    if (StringUtils.isNotEmpty(one.getParentCode())) {
      ChannelOrg parent = channelOrgRepository.findDetailsByCode(one.getParentCode(), TenantUtils.getTenantCode());
      if (parent != null) {
        respVo.setParentName(parent.getChannelOrgName());
      }
    }
    //组装关联数据
    Map<String, JSONArray> map = new HashMap<>();
    if (!CollectionUtils.isEmpty(channelOrgRelationStrategies)) {
      for (ChannelOrgRelationStrategy channelOrgRelationStrategy : channelOrgRelationStrategies) {
        map.put(channelOrgRelationStrategy.getKey(), channelOrgRelationStrategy.findByChannelOrgChannel(channelOrgCode));
      }
    }
    respVo.setRelationMap(map);
    return respVo;
  }

  @Override
  public List<ChannelOrgVo> findParentByChannelOrgCode(String channelOrgCode) {
    ChannelOrg org = channelOrgRepository.findByChannelOrgCode(channelOrgCode);
    if(ObjectUtils.isEmpty(org)){
      return Lists.newArrayList();
    }
    Set<String> parentRuleCodes = Sets.newHashSet();
    parentRuleCodes.add(org.getRuleCode());
    if(StringUtils.isNotEmpty(org.getRuleCode())){
      TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
      parentRuleCodes = treeRuleCodeStrategy.findParentRuleCodeByRuleCodes(
              ChannelOrgConstant.RULE_CODE_LENGTH, Lists.newArrayList(org.getRuleCode()));
    }
    List<ChannelOrg> parentOrgList = channelOrgRepository.findListByRuleCodes(parentRuleCodes);
    List<ChannelOrgVo> orgVoList = parentOrgList.stream().map(m -> {
      ChannelOrgVo orgVo = new ChannelOrgVo();
      BeanUtils.copyProperties(m, orgVo);
      return orgVo;
    }).collect(Collectors.toList());
    return orgVoList;
  }

  @Override
  public List<ChannelOrgVo> findParentAndChildrenByOrgCode(String tenantCode) {
    ChannelOrg org = channelOrgRepository.findByChannelOrgCode(tenantCode);
    List<ChannelOrgVo> list = Lists.newArrayList();
    if(ObjectUtils.isEmpty(org)){
      return list;
    }

    /*String parentCode = org.getParentCode();
    log.info("指定企业组织查询父级的下级ChannelOrgVo数parentCode，{}",parentCode);
    if (StringUtils.isNotEmpty(parentCode)){
      org = channelOrgRepository.findByChannelOrgCode(parentCode);
    }*/
    /*log.info("指定企业组织查询父级的下级ChannelOrgVo数RuleCode，{}",org.getRuleCode());
    if(StringUtils.isEmpty(org.getRuleCode())){
      return list;
    }*/
    List<ChannelOrg> parentOrgList =new ArrayList<>();
    parentOrgList.add(org);
   // List<ChannelOrg> parentOrgList = channelOrgRepository.findChildrenOrgByRuleCode(org.getRuleCode());

    List<ChannelOrgVo> channelOrgVos = (List<ChannelOrgVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
        parentOrgList, ChannelOrg.class, ChannelOrgVo.class, HashSet.class, ArrayList.class);
    log.info("指定企业组织查询父级的下级ChannelOrgVo结果:{}", JSON.toJSONString(channelOrgVos));
    return channelOrgVos;

  }

  @Override
  public List<ChannelOrgVo> findGreatGrandFatherByOrgCode(String tenantCode) {
    ChannelOrg org = channelOrgRepository.findByChannelOrgCode(tenantCode);
    List<ChannelOrgVo> list = Lists.newArrayList();
    if(ObjectUtils.isEmpty(org)){
      return list;
    }
    String parentCode = org.getParentCode();
    log.info("指定企业组织查询2父级的下级ChannelOrgVo数parentCode，{}",parentCode);
    if (StringUtils.isNotEmpty(parentCode)){
      org = channelOrgRepository.findByChannelOrgCode(parentCode);
    }
    if(!ObjectUtils.isEmpty(org)){
      String parentCode2 = org.getParentCode();
      log.info("指定企业组织查询祖级的下级ChannelOrgVo数parentCode2，{}",parentCode2);
      if (StringUtils.isNotEmpty(parentCode2)){
        org = channelOrgRepository.findByChannelOrgCode(parentCode2);
      }
    }
    if(!ObjectUtils.isEmpty(org)){
      String parentCode3 = org.getParentCode();
      log.info("指定企业组织查询祖级的下级ChannelOrgVo数parentCode3，{}",parentCode3);
      if (StringUtils.isNotEmpty(parentCode3)){
        org = channelOrgRepository.findByChannelOrgCode(parentCode3);
      }
    }
    log.info("指定企业组织查询祖级的所有下级ChannelOrgVo数RuleCode，{}",org.getRuleCode());
    if(StringUtils.isEmpty(org.getRuleCode())){
      return list;
    }
     List<ChannelOrg> parentOrgList = channelOrgRepository.findChildrenOrgByRuleCode(org.getRuleCode());

    List<ChannelOrgVo> channelOrgVos = (List<ChannelOrgVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
        parentOrgList, ChannelOrg.class, ChannelOrgVo.class, HashSet.class, ArrayList.class);
    log.info("指定企业组织查询祖级的下级ChannelOrgVo结果:{}", JSON.toJSONString(channelOrgVos));
    return channelOrgVos;

  }
}
