package com.biz.crm.mdm.business.channel.org.local.service.notifier;
/**
 * Created by Bao Hongbin on 2021-11-02 16:13.
 */

import com.biz.crm.mdm.business.channel.org.local.repository.ChannelOrgPositionRepository;
import com.biz.crm.mdm.business.channel.org.local.entity.ChannelOrgPosition;
import com.biz.crm.mdm.business.position.sdk.event.PositionEventListener;
import com.biz.crm.mdm.business.position.sdk.vo.PositionEventVo;
import com.biz.crm.mdm.business.position.sdk.vo.PositionRelationVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @program: crm
 * @description:
 * @author: Bao Hongbin
 * @create: 2021-11-02 16:13
 **/
@Service
public class ChannelOrgPositionEventListenerImpl implements PositionEventListener {
  @Autowired(required = false)
  private ChannelOrgPositionRepository channelOrgPositionRepository;

  /**
   * 不需要实现
   * @param vo 创建时的vo
   */
  @Override
  public void onCreate(PositionEventVo vo) {

  }

  /**
   * 不需要实现
   * @param vos 创建时的vo
   */
  @Override
  public void onCreate(List<PositionEventVo> vos) {

  }

  /**
   * 不需要实现
   * @param oldVo 修改之前的vo
   * @param newVo 修改之后的vo
   */
  @Override
  public void onUpdate(PositionEventVo oldVo, PositionEventVo newVo) {

  }

  /**
   * 不需要实现
   * @param voList 禁用vo信息
   */
  @Override
  public void onDisable(List<PositionEventVo> voList) {

  }

  /**
   * 不需要实现
   * @param voList 禁用vo信息
   */
  @Override
  public void onEnable(List<PositionEventVo> voList) {

  }

  @Override
  public void onDelete(List<PositionEventVo> voList) {
    if (CollectionUtils.isEmpty(voList)) {
      return;
    }
    List<String> positionCode = voList.stream().map(PositionEventVo::getPositionCode).collect(Collectors.toList());
    List<ChannelOrgPosition> channelOrgPositions = channelOrgPositionRepository.findListByPositionCode(positionCode, TenantUtils.getTenantCode());
    Validate.isTrue(CollectionUtils.isEmpty(channelOrgPositions), "存在已被渠道组织关联的职位");
  }

  /**
   * 不需要实现
   * @param positionCodes 职位编码集合
   * @return
   */
  @Override
  public List<PositionRelationVo> onRequestByPositionCodes(List<String> positionCodes) {
    return null;
  }
}
