/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.channel.org.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.mdm.business.channel.org.local.entity.ChannelOrgPosition;
import com.biz.crm.mdm.business.channel.org.local.mapper.ChannelOrgPositionMapper;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ChannelOrgPositionRepository
extends ServiceImpl<ChannelOrgPositionMapper, ChannelOrgPosition> {
    public void removeRelationByCustomerOrgCodeAndPositionCodes(String customerOrgCode, List<String> positionCodeList, String tenantCode) {
        Validate.notEmpty((CharSequence)customerOrgCode, (String)"\u6e20\u9053\u7ec4\u7ec7\u7f16\u7801\u5fc5\u987b\u4f20\u5165\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(positionCodeList) ? 1 : 0) != 0, (String)"\u9700\u8981\u5173\u8054\u7684\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(ChannelOrgPosition::getChannelOrgCode, (Object)customerOrgCode)).in(ChannelOrgPosition::getPositionCode, positionCodeList)).remove();
    }

    public List<ChannelOrgPosition> findListByPositionCode(List<String> positionCode, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(ChannelOrgPosition::getPositionCode, positionCode)).list();
    }

    public List<ChannelOrgPosition> findListByCustomerOrgCodes(List<String> customerOrgCodes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(ChannelOrgPosition::getChannelOrgCode, customerOrgCodes)).list();
    }

    public void deleteByIdsAndTenantCode(List<String> ids, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).remove();
    }
}

