/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.channel.org.local.service.internal;

import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.business.common.sdk.utils.TreeUtil;
import com.biz.crm.business.common.sdk.vo.TreeVo;
import com.biz.crm.mdm.business.channel.org.local.repository.ChannelOrgRepository;
import com.biz.crm.mdm.business.channel.org.local.service.ChannelOrgTreeVoService;
import com.biz.crm.mdm.business.channel.org.sdk.dto.ChannelOrgTreeDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChannelOrgTreeVoServiceImpl
implements ChannelOrgTreeVoService {
    @Autowired(required=false)
    private ChannelOrgRepository channelOrgRepository;
    @Autowired(required=false)
    private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;

    @Override
    public List<TreeVo> findTree(ChannelOrgTreeDto treeDto) {
        TreeRuleCodeStrategy treeRuleCodeStrategy;
        Set set;
        treeDto = Optional.ofNullable(treeDto).orElse(new ChannelOrgTreeDto());
        List<Object> tree = new ArrayList<TreeVo>();
        List<Object> list = new ArrayList();
        list = StringUtils.isBlank((CharSequence)treeDto.getChannelOrgLevel()) ? this.channelOrgRepository.findListLikeName(treeDto.getEnableStatus(), treeDto.getName(), TenantUtils.getTenantCode()) : this.channelOrgRepository.findListLikeNameAndChannelOrgLevel(treeDto.getEnableStatus(), treeDto.getName(), TenantUtils.getTenantCode(), treeDto.getChannelOrgLevel());
        if (CollectionUtils.isEmpty(list)) {
            return tree;
        }
        if (StringUtils.isNotEmpty((CharSequence)treeDto.getName()) && !CollectionUtils.isEmpty((Collection)(set = (treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null)).findParentRuleCodeByRuleCodes(3, list.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList()))))) {
            List partition = Lists.partition(new ArrayList(set), (int)500);
            list = new ArrayList();
            for (List part : partition) {
                list.addAll(this.channelOrgRepository.findListByRuleCodes(new HashSet<String>(part), TenantUtils.getTenantCode()));
            }
        }
        List collect = list.stream().map(x -> {
            TreeVo treeVo = new TreeVo();
            treeVo.setId(x.getId());
            treeVo.setParentCode(x.getParentCode());
            treeVo.setCode(x.getChannelOrgCode());
            treeVo.setName(x.getChannelOrgName());
            return treeVo;
        }).collect(Collectors.toList());
        tree = TreeUtil.generateTreeByParentCode(collect);
        if (StringUtils.isNotEmpty((CharSequence)treeDto.getExcludeCodeAndChildren())) {
            TreeUtil.excludeCodeAndChildren(tree, (String)treeDto.getExcludeCodeAndChildren());
        }
        return tree;
    }
}

