/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.channel.org.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.channel.org.local.entity.ChannelOrgType;
import com.biz.crm.mdm.business.channel.org.local.repository.ChannelOrgTypeRepository;
import com.biz.crm.mdm.business.channel.org.local.service.ChannelOrgTypeService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="channelOrgTypeService")
public class ChannelOrgTypeServiceImpl
implements ChannelOrgTypeService {
    @Autowired
    private ChannelOrgTypeRepository channelOrgTypeRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;

    @Override
    public ChannelOrgType findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (ChannelOrgType)((Object)this.channelOrgTypeRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public ChannelOrgType create(ChannelOrgType channelOrgType) {
        this.createValidate(channelOrgType);
        this.channelOrgTypeRepository.saveOrUpdate((Object)channelOrgType);
        return channelOrgType;
    }

    @Override
    @Transactional
    public ChannelOrgType update(ChannelOrgType channelOrgType) {
        ChannelOrgType current = (ChannelOrgType)((Object)this.channelOrgTypeRepository.getById((Serializable)((Object)channelOrgType)));
        Validate.notNull((Object)((Object)current), (String)"\u672a\u67e5\u8be2\u5230\u8981\u4fee\u6539\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        BeanUtils.copyProperties((Object)((Object)channelOrgType), (Object)((Object)current), (String[])new String[]{"id", "channelOrgTypeCode", "tenantCode", "createAccount", "delFlag", "enableStatus", "createName", "createTime"});
        this.updateValidate(current);
        this.channelOrgTypeRepository.saveOrUpdate((Object)current);
        return current;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ChannelOrgType> channelOrgTypes = this.channelOrgTypeRepository.findByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty(channelOrgTypes) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u5220\u9664\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        channelOrgTypes.stream().forEach(channelOrgType -> channelOrgType.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
        this.channelOrgTypeRepository.saveOrUpdateBatch(channelOrgTypes);
    }

    @Override
    @Transactional
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ChannelOrgType> channelOrgTypes = this.channelOrgTypeRepository.findEnableStatusByIds(EnableStatusEnum.DISABLE, idList);
        Validate.isTrue((!CollectionUtils.isEmpty(channelOrgTypes) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u542f\u7528\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        channelOrgTypes.stream().forEach(channelOrgType -> channelOrgType.setEnableStatus(EnableStatusEnum.ENABLE.getCode()));
        this.channelOrgTypeRepository.saveOrUpdateBatch(channelOrgTypes);
    }

    @Override
    @Transactional
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ChannelOrgType> channelOrgTypes = this.channelOrgTypeRepository.findEnableStatusByIds(EnableStatusEnum.ENABLE, idList);
        Validate.isTrue((!CollectionUtils.isEmpty(channelOrgTypes) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u7981\u7528\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        channelOrgTypes.stream().forEach(channelOrgType -> channelOrgType.setEnableStatus(EnableStatusEnum.DISABLE.getCode()));
        this.channelOrgTypeRepository.saveOrUpdateBatch(channelOrgTypes);
    }

    @Override
    public ChannelOrgType findByChannelOrgTypeCode(String channelOrgTypeCode) {
        if (StringUtils.isBlank((CharSequence)channelOrgTypeCode)) {
            return null;
        }
        return this.channelOrgTypeRepository.findByChannelOrgTypeCode(channelOrgTypeCode);
    }

    @Override
    public Page<ChannelOrgType> findByConditions(Pageable pageable, ChannelOrgType channelOrgType) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        if (channelOrgType == null) {
            channelOrgType = new ChannelOrgType();
        }
        return this.channelOrgTypeRepository.findByConditions(pageable, channelOrgType);
    }

    private void createValidate(ChannelOrgType channelOrgType) {
        Validate.notNull((Object)((Object)channelOrgType), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        channelOrgType.setId(null);
        channelOrgType.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        channelOrgType.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        channelOrgType.setTenantCode(TenantUtils.getTenantCode());
        channelOrgType.setChannelOrgTypeCode((String)this.generateCodeService.generateCode("CDT", 1).get(0));
        Validate.notBlank((CharSequence)channelOrgType.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)channelOrgType.getChannelOrgLevel(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6e20\u9053\u7ec4\u7ec7\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)channelOrgType.getChannelOrgTypeCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6e20\u9053\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)channelOrgType.getChannelOrgTypeName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6e20\u9053\u7ec4\u7ec7\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(ChannelOrgType channelOrgType) {
        Validate.notNull((Object)((Object)channelOrgType), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)channelOrgType.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)channelOrgType.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)channelOrgType.getChannelOrgLevel(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6e20\u9053\u7ec4\u7ec7\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)channelOrgType.getChannelOrgTypeCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6e20\u9053\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)channelOrgType.getChannelOrgTypeName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6e20\u9053\u7ec4\u7ec7\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

