package com.biz.crm.mdm.business.channel.org.local.controller;
/**
 * Created by Bao Hongbin on 2021-10-28 17:43.
 */

import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.vo.TreeVo;
import com.biz.crm.mdm.business.channel.org.local.service.ChannelOrgTreeVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 迁移原/baseTreeController/channelOrgTree接口
 * @program: crm
 * @description: 渠道组织：TreeVo：渠道组织树
 * @author: Bao Hongbin
 * @create: 2021-10-28 17:43
 **/

@Api(tags = "渠道组织：TreeVo：渠道组织树")
@Slf4j
@RestController
@RequestMapping("/v1/channelOrg/tree")
public class ChannelOrgTreeVoController {
  @Autowired(required = false)
  private ChannelOrgTreeVoService channelOrgTreeVoService;

  @ApiOperation(value = "渠道组织树")
  @GetMapping
  public Result<List<TreeVo>> findTree(@ApiParam(name = "treeDto", value = "查询Dto") TreeDto treeDto) {
    try {
      List<TreeVo> result = this.channelOrgTreeVoService.findTree(treeDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
