package com.biz.crm.mdm.business.channel.org.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.ibatis.type.JdbcType;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 渠道组织实体类
 */
@Data
@ApiModel(value = "channelOrg", description = "渠道组织实体类")
@TableName("mdm_channel_org")
@Entity
@Table(name = "mdm_channel_org", indexes = {
        @Index(name = "CO_INDEX1", columnList = "channel_org_code", unique = true),
        @Index(name = "CO_INDEX2", columnList = "parent_code"),
        @Index(name = "CO_INDEX3", columnList = "rule_code"),
})
@org.hibernate.annotations.Table(appliesTo = "mdm_channel_org", comment = "渠道组织表")
public class ChannelOrg extends TenantFlagTreeOpEntity {

  private static final long serialVersionUID = -1674819897603635039L;

  /**
   * 渠道组织编码
   */
  @ApiModelProperty("渠道组织编码")
  @TableField(value = "channel_org_code", jdbcType = JdbcType.VARCHAR)
  @Column(name = "channel_org_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '渠道组织编码'")
  private String channelOrgCode;

  /**
   * 渠道组织名称
   */
  @ApiModelProperty("渠道组织名称")
  @TableField(value = "channel_org_name")
  @Column(name = "channel_org_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT '渠道组织名称'")
  private String channelOrgName;

  /**
   * 渠道组织层级
   */
  @ApiModelProperty("渠道组织层级")
  @TableField(value = "channel_org_level")
  @Column(name = "channel_org_level", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '渠道组织层级'")
  private String channelOrgLevel;

  /**
   * 渠道组织类型
   */
  @ApiModelProperty("渠道组织类型")
  @TableField(value = "channel_org_type")
  @Column(name = "channel_org_type", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '渠道组织类型'")
  private String channelOrgType;

  /**
   * 渠道组织描述
   */
  @ApiModelProperty("渠道组织描述")
  @TableField(value = "channel_org_desc")
  @Column(name = "channel_org_desc", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '渠道组织描述'")
  private String channelOrgDesc;

  /**
   * 上级编码
   */
  @ApiModelProperty("上级编码")
  @TableField(value = "parent_code",jdbcType = JdbcType.VARCHAR)
  @Column(name = "parent_code",nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '上级编码'")
  private String parentCode;

}
