package com.biz.crm.mdm.business.channel.org.local.event;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.channel.org.sdk.dto.ChannelOrgEventBatchDto;
import com.biz.crm.mdm.business.channel.org.sdk.dto.ChannelOrgEventDto;
import com.biz.crm.mdm.business.channel.org.sdk.dto.ChannelOrgEventUpdateDto;
import com.biz.crm.mdm.business.channel.org.sdk.event.ChannelOrgNebulaEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author yangshen
 * @version 1.0
 * @date 2022/12/28 10:37
 * @ClassName ChannelOrgNebulaLogEventListenerImpl
 * @Description TODO 渠道组织事件监听
 */
@Component
public class ChannelOrgNebulaLogEventListenerImpl implements ChannelOrgNebulaEventListener {


    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    /**
     * 新建时生效
     * @param channelOrgEventDto
     */
    @Override
    public void onCreate(ChannelOrgEventDto channelOrgEventDto) {
        String onlyKey = channelOrgEventDto.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(null);
        crmBusinessLogDto.setNewObject(channelOrgEventDto);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 删除时生效
     * @param channelOrgEventBatchDto
     */
    @Override
    public void onDeleteBatch(ChannelOrgEventBatchDto channelOrgEventBatchDto) {
        List<ChannelOrgEventDto> channelOrgEventDtoList = channelOrgEventBatchDto.getChannelOrgEventDtoList();
        if (CollectionUtils.isEmpty(channelOrgEventDtoList)) {
            return;
        }
        channelOrgEventDtoList.forEach(channelOrgEventDto -> {
            String onlyKey = channelOrgEventDto.getId();
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject(channelOrgEventDto);
            crmBusinessLogDto.setNewObject(null);
            crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }

    /**
     * 开启时生效
     * @param channelOrgEventBatchDto 新数据
     */
    @Override
    public void onEnableBatch(ChannelOrgEventBatchDto channelOrgEventBatchDto) {
        List<ChannelOrgEventDto> channelOrgEventDtoList = channelOrgEventBatchDto.getChannelOrgEventDtoList();
        if (CollectionUtils.isEmpty(channelOrgEventDtoList)) {
            return;
        }
        channelOrgEventDtoList.forEach(channelOrgEventDto -> {
            String onlyKey = channelOrgEventDto.getId();
            ChannelOrgEventDto oldObj = new ChannelOrgEventDto();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            ChannelOrgEventDto newObj = new ChannelOrgEventDto();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(channelOrgEventDto.getEnableStatus());
            ChannelOrgEventUpdateDto channelOrgEventUpdateDto = new ChannelOrgEventUpdateDto();
            channelOrgEventUpdateDto.setNewChannelOrgEventDto(newObj);
            channelOrgEventUpdateDto.setOldChannelOrgEventDto(oldObj);
            this.onUpdate(channelOrgEventUpdateDto);
        });
    }

    /**
     * 禁用时生效
     * @param channelOrgEventBatchDto 旧数据
     */
    @Override
    public void onDisableBatch(ChannelOrgEventBatchDto channelOrgEventBatchDto) {
        List<ChannelOrgEventDto> channelOrgEventDtoList = channelOrgEventBatchDto.getChannelOrgEventDtoList();
        if (CollectionUtils.isEmpty(channelOrgEventDtoList)) {
            return;
        }
        channelOrgEventDtoList.forEach(channelOrgEventDto -> {
            String onlyKey = channelOrgEventDto.getId();
            ChannelOrgEventDto oldObj = new ChannelOrgEventDto();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(channelOrgEventDto.getEnableStatus());
            ChannelOrgEventDto newObj = new ChannelOrgEventDto();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            ChannelOrgEventUpdateDto channelOrgEventUpdateDto = new ChannelOrgEventUpdateDto();
            channelOrgEventUpdateDto.setNewChannelOrgEventDto(newObj);
            channelOrgEventUpdateDto.setOldChannelOrgEventDto(oldObj);
            this.onUpdate(channelOrgEventUpdateDto);
        });
    }

    /**
     * 更新时生效
     * @param channelOrgEventUpdateDto
     */
    @Override
    public void onUpdate(ChannelOrgEventUpdateDto channelOrgEventUpdateDto) {
        ChannelOrgEventDto newObj = channelOrgEventUpdateDto.getNewChannelOrgEventDto();
        ChannelOrgEventDto oldObj = channelOrgEventUpdateDto.getOldChannelOrgEventDto();
        String onlyKey = newObj.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(oldObj);
        crmBusinessLogDto.setNewObject(newObj);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
}
