package com.biz.crm.mdm.business.channel.org.local.service.internal;
/**
 * Created by Bao Hongbin on 2021-10-28 18:06.
 */

import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.business.common.sdk.utils.TreeUtil;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.channel.org.local.repository.ChannelOrgRepository;
import com.biz.crm.mdm.business.channel.org.local.service.ChannelOrgLazyTreeVoService;
import com.biz.crm.mdm.business.channel.org.local.entity.ChannelOrg;
import com.biz.crm.mdm.business.channel.org.sdk.constant.ChannelOrgConstant;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @program: crm
 * @description: 渠道组织懒加载树服务实现
 * @author: Bao Hongbin
 * @create: 2021-10-28 18:06
 **/
@Service
public class ChannelOrgLazyTreeVoServiceImpl implements ChannelOrgLazyTreeVoService {
  @Autowired(required = false)
  private ChannelOrgRepository channelOrgRepository;
  @Autowired(required = false)
  private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;

  @Override
  public List<LazyTreeVo> findLazyTree(TreeDto treeDto) {
    treeDto = Optional.ofNullable(treeDto).orElse(new TreeDto());
    List<LazyTreeVo> list = new ArrayList<>();
    //设置排除ruleCode
    String excludeRuleCode = "";
    if (StringUtils.isNotEmpty(treeDto.getExcludeCodeAndChildren())) {
      //如果排除编码不为空，说明存在查询时需要排除的数据及其所以子集，则设置需要排除的ruleCode，通过ruleCode向下排除
      ChannelOrg one =
          channelOrgRepository.findDetailsByCode(treeDto.getExcludeCodeAndChildren(), TenantUtils.getTenantCode());
      if (one != null) {
        excludeRuleCode = one.getRuleCode();
      }
    }
    if (StringUtils.isNotEmpty(treeDto.getParentCode())) {
      //如果父级编码不为空，说明本次只查询该编码的下一级数据构建成树形结构
      list.addAll(channelOrgRepository.findLazyTreeList(treeDto.getEnableStatus(),
          null, treeDto.getParentCode(), null, null, excludeRuleCode, TenantUtils.getTenantCode()));
    } else if (!StringUtils.isEmpty(treeDto.getName())) {
      //如果名称不为空，说明本次查询是通过名称模糊查询，则需要查询出所有符合模糊查询条件的数据，并查询出其上级构建成树形结构
      List<ChannelOrg> likeList =
          channelOrgRepository.findListLikeName(treeDto.getEnableStatus(), treeDto.getName(), TenantUtils.getTenantCode());
      if (!CollectionUtils.isEmpty(likeList)) {
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        Set<String> parentRuleCodes = treeRuleCodeStrategy.findParentRuleCodeByRuleCodes(
            ChannelOrgConstant.RULE_CODE_LENGTH, likeList.stream().map(ChannelOrg::getRuleCode).collect(Collectors.toList()));
        list.addAll(channelOrgRepository.findLazyTreeList(treeDto.getEnableStatus(), null, null,
            null, new ArrayList<>(parentRuleCodes), excludeRuleCode, TenantUtils.getTenantCode()));
      }
    } else {
      //否则，说明本次查询是查询顶层数据
      list.addAll(channelOrgRepository.findLazyTreeList(treeDto.getEnableStatus(), true, null,
          null, null, excludeRuleCode, TenantUtils.getTenantCode()));
    }
    if (!CollectionUtils.isEmpty(list)) {
      for (LazyTreeVo lazyTreeVo : list) {
        lazyTreeVo.setHasChild(null != lazyTreeVo.getHasChildFlag() && lazyTreeVo.getHasChildFlag().compareTo(0) > 0);
      }
      return TreeUtil.generateLazyTreeByParentCode(list);
    }
    return new ArrayList<>();
  }
}
