/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.channel.org.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.channel.org.local.entity.ChannelOrg;
import com.biz.crm.mdm.business.channel.org.local.mapper.ChannelOrgMapper;
import com.biz.crm.mdm.business.channel.org.sdk.dto.ChannelOrgPaginationDto;
import com.biz.crm.mdm.business.channel.org.sdk.vo.ChannelOrgVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ChannelOrgRepository
extends ServiceImpl<ChannelOrgMapper, ChannelOrg> {
    public List<ChannelOrg> findListByName(String customerOrgName, boolean isLike, String tenantCode) {
        Validate.notBlank((CharSequence)customerOrgName, (String)"\u6e20\u9053\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(!isLike, ChannelOrg::getChannelOrgName, (Object)customerOrgName)).like(isLike, ChannelOrg::getChannelOrgName, (Object)customerOrgName)).list();
    }

    public ChannelOrg findDetailsByCode(String customerOrgCode, String tenantCode) {
        Validate.notBlank((CharSequence)customerOrgCode, (String)"\u6e20\u9053\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (ChannelOrg)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(ChannelOrg::getChannelOrgCode, (Object)customerOrgCode)).one());
    }

    public List<ChannelOrg> findListByCode(String customerOrgCode, String tenantCode) {
        Validate.notBlank((CharSequence)customerOrgCode, (String)"\u6e20\u9053\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(ChannelOrg::getChannelOrgCode, (Object)customerOrgCode)).list();
    }

    public ChannelOrg findDetailsById(String id, String tenantCode) {
        Validate.notBlank((CharSequence)id, (String)"\u6e20\u9053\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (ChannelOrg)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidEntity::getId, (Object)id)).one());
    }

    public List<ChannelOrg> findChildrenListByParentCode(String parentCode, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).isNull(!StringUtils.isNotEmpty((CharSequence)parentCode), ChannelOrg::getParentCode)).eq(StringUtils.isNotEmpty((CharSequence)parentCode), ChannelOrg::getParentCode, (Object)parentCode)).list();
    }

    public List<ChannelOrg> findListByIds(List<String> ids, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).list();
    }

    public List<ChannelOrg> findListByRuleCodes(Set<String> ruleCodes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(TenantFlagTreeOpEntity::getRuleCode, ruleCodes)).list();
    }

    public List<ChannelOrg> findCurAndChildrenByRuleCodeList(List<String> ruleCodes, String enableStatus, String tenantCode) {
        return ((ChannelOrgMapper)this.baseMapper).findCurAndChildrenByRuleCodeList(ruleCodes, enableStatus, tenantCode, DelFlagStatusEnum.NORMAL);
    }

    public List<ChannelOrg> findChildrenListByParentCodes(List<String> parentCodes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(ChannelOrg::getParentCode, parentCodes)).list();
    }

    public void updateOrphanParentCodeNull(String tenantCode) {
        ((ChannelOrgMapper)this.baseMapper).updateOrphanParentCodeNull(tenantCode, DelFlagStatusEnum.NORMAL);
    }

    public List<ChannelOrg> findListWithoutParentCode(String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).isNull(ChannelOrg::getParentCode)).list();
    }

    public List<ChannelOrg> findAll(String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public Page<ChannelOrgVo> findByConditions(Pageable pageable, ChannelOrgPaginationDto channelOrgPaginationDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((ChannelOrgMapper)this.baseMapper).findByConditions((Page<ChannelOrgVo>)page, channelOrgPaginationDto, DelFlagStatusEnum.NORMAL);
    }

    public List<LazyTreeVo> findLazyTreeList(String enableStatus, Boolean topOnly, String parentCode, List<String> codeList, List<String> ruleCodeList, String excludeRuleCode, String tenantCode) {
        return ((ChannelOrgMapper)this.baseMapper).findLazyTreeList(enableStatus, topOnly, parentCode, codeList, ruleCodeList, excludeRuleCode, tenantCode, DelFlagStatusEnum.NORMAL);
    }

    public List<ChannelOrg> findListLikeName(String enableStatus, String name, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(StringUtils.isNotEmpty((CharSequence)enableStatus), UuidFlagOpEntity::getEnableStatus, (Object)enableStatus)).like(StringUtils.isNotEmpty((CharSequence)name), ChannelOrg::getChannelOrgName, (Object)name)).list();
    }

    public List<ChannelOrg> findListByCodes(List<String> codes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(ChannelOrg::getChannelOrgCode, codes)).list();
    }

    public List<ChannelOrg> findCurAndChildrenByOrgCodeList(List<String> orgCodes, String enableStatus, String tenantCode) {
        return ((ChannelOrgMapper)this.baseMapper).findCurAndChildrenByOrgCodeList(orgCodes, enableStatus, tenantCode);
    }

    public void setParentCodeNull(String id) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ChannelOrg::getParentCode, null)).eq(UuidEntity::getId, (Object)id)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }

    public void setParentCodeAndRuleCodeNull(String id) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ChannelOrg::getParentCode, null)).set(TenantFlagTreeOpEntity::getRuleCode, (Object)"")).eq(UuidEntity::getId, (Object)id)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }

    public ChannelOrg findByCustomerOrgCode(String code) {
        return (ChannelOrg)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(ChannelOrg::getChannelOrgCode, (Object)code)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public List<ChannelOrg> findByCustomerOrgCodes(List<String> code) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(ChannelOrg::getChannelOrgCode, code)).list();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(UuidFlagOpEntity::getEnableStatus, (Object)enableStatus.getCode())).update();
    }

    public String findRuleCodeByChannelOrgCode(String channelOrgCode) {
        ChannelOrg entity = (ChannelOrg)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(ChannelOrg::getChannelOrgCode, (Object)channelOrgCode)).one());
        if (ObjectUtils.isEmpty((Object)((Object)entity))) {
            return null;
        }
        return StringUtils.isEmpty((CharSequence)entity.getRuleCode()) ? null : entity.getRuleCode();
    }
}

