/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.channel.org.local.service.helper;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.mdm.business.channel.org.local.entity.ChannelOrg;
import com.biz.crm.mdm.business.channel.org.local.repository.ChannelOrgRepository;
import com.biz.crm.mdm.business.channel.org.sdk.dto.ChannelOrgCreateDto;
import com.biz.crm.mdm.business.channel.org.sdk.dto.ChannelOrgUpdateDto;
import com.biz.crm.mdm.business.channel.org.sdk.event.ChannelOrgEventListener;
import com.biz.crm.mdm.business.channel.org.sdk.vo.ChannelOrgVo;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ChannelOrgServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(ChannelOrgServiceHelper.class);
    @Autowired(required=false)
    private ChannelOrgRepository channelOrgRepository;
    @Autowired(required=false)
    @Lazy
    private List<ChannelOrgEventListener> channelOrgEventListeners;

    public void createValidation(ChannelOrgCreateDto channelOrgCreateDto) {
        Validate.notNull((Object)channelOrgCreateDto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        log.info("\u65b0\u589e\u6e20\u9053\u7ec4\u7ec7\u8bf7\u6c42dto\uff1a{}", (Object)JsonUtils.obj2JsonString((Object)channelOrgCreateDto));
        Validate.notBlank((CharSequence)channelOrgCreateDto.getChannelOrgName(), (String)"\u6e20\u9053\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ChannelOrg> channelOrgs = this.channelOrgRepository.findListByName(channelOrgCreateDto.getChannelOrgName(), false, TenantUtils.getTenantCode());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(channelOrgs), (String)"\u6e20\u9053\u7ec4\u7ec7\u540d\u79f0\u5df2\u5b58\u5728", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)channelOrgCreateDto.getChannelOrgCode())) {
            Validate.isTrue((channelOrgCreateDto.getChannelOrgCode().length() < 64 ? 1 : 0) != 0, (String)"\u6e20\u9053\u7ec4\u7ec7\u7f16\u7801\u4fe1\u606f\uff0c\u5728\u8fdb\u884c\u65b0\u589e\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            ChannelOrg channelOrg = this.channelOrgRepository.findDetailsByCode(channelOrgCreateDto.getChannelOrgCode(), TenantUtils.getTenantCode());
            Validate.isTrue((null == channelOrg ? 1 : 0) != 0, (String)("\u7f16\u7801[" + channelOrgCreateDto.getChannelOrgCode() + "]\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)channelOrgCreateDto.getParentCode())) {
            ChannelOrg parent = this.channelOrgRepository.findDetailsByCode(channelOrgCreateDto.getParentCode(), TenantUtils.getTenantCode());
            Validate.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u7f16\u7801\u65e0\u6548", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)channelOrgCreateDto.getChannelOrgType(), (String)"\u65b0\u589e\u4fe1\u606f\u65f6\uff0c\u6e20\u9053\u7ec4\u7ec7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)channelOrgCreateDto.getEnableStatus(), (String)"\u65b0\u589e\u4fe1\u606f\u65f6\uff0c\u6e20\u9053\u7ec4\u7ec7\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((channelOrgCreateDto.getChannelOrgName().length() < 128 ? 1 : 0) != 0, (String)"\u6e20\u9053\u7ec4\u7ec7\u540d\u79f0\u4fe1\u606f\uff0c\u5728\u8fdb\u884c\u65b0\u589e\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    public void updateValidation(ChannelOrgUpdateDto channelOrgUpdateDto) {
        Validate.notNull((Object)channelOrgUpdateDto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        log.info("\u7f16\u8f91\u6e20\u9053\u7ec4\u7ec7\u8bf7\u6c42dto\uff1a{}", (Object)JsonUtils.obj2JsonString((Object)channelOrgUpdateDto));
        Validate.notBlank((CharSequence)channelOrgUpdateDto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u6e20\u9053\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ChannelOrg channelOrg = this.channelOrgRepository.findDetailsById(channelOrgUpdateDto.getId(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)channelOrg), (String)"\u65e0\u6548\u7684\u4e1a\u52a1\u6280\u672f\u7f16\u53f7\u4fe1\u606f", (Object[])new Object[0]);
        ChannelOrg detailsByCode = this.channelOrgRepository.findDetailsByCode(channelOrgUpdateDto.getChannelOrgCode(), TenantUtils.getTenantCode());
        Validate.isTrue((detailsByCode == null || channelOrgUpdateDto.getId().equals(detailsByCode.getId()) ? 1 : 0) != 0, (String)"\u6e20\u9053\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        List idsByName = ((List)Optional.ofNullable(this.channelOrgRepository.findListByName(channelOrgUpdateDto.getChannelOrgName(), false, TenantUtils.getTenantCode())).orElse(new ArrayList())).stream().map(UuidEntity::getId).collect(Collectors.toList());
        Validate.isTrue((CollectionUtils.isEmpty(idsByName) || idsByName.size() == 1 && idsByName.contains(channelOrgUpdateDto.getId()) ? 1 : 0) != 0, (String)"\u6e20\u9053\u7ec4\u7ec7\u540d\u79f0\u5df2\u5b58\u5728", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)channelOrg.getRuleCode(), (String)"\u5f53\u524d\u6e20\u9053\u7ec4\u7ec7ruleCode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)channelOrgUpdateDto.getChannelOrgCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u6e20\u9053\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)channelOrg.getChannelOrgCode().equals(channelOrgUpdateDto.getChannelOrgCode()), (String)"\u6e20\u9053\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)channelOrgUpdateDto.getParentCode())) {
            ChannelOrg parent = this.channelOrgRepository.findDetailsByCode(channelOrgUpdateDto.getParentCode(), TenantUtils.getTenantCode());
            Validate.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u6e20\u9053\u7ec4\u7ec7\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            Validate.isTrue((!parent.getId().equals(channelOrg.getId()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u6e20\u9053\u7ec4\u7ec7\u4e0d\u80fd\u662f\u81ea\u5df1", (Object[])new Object[0]);
            Validate.isTrue((!parent.getRuleCode().startsWith(channelOrg.getRuleCode()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u6e20\u9053\u7ec4\u7ec7\u4e0d\u80fd\u662f\u5f53\u524d\u5c42\u7ea7\u7684\u4e0b\u7ea7", (Object[])new Object[0]);
            if (!parent.getChannelOrgCode().equals(channelOrg.getParentCode())) {
                Validate.notBlank((CharSequence)parent.getRuleCode(), (String)"\u4e0a\u7ea7\u6e20\u9053\u7ec4\u7ec7ruleCode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
        }
        Validate.notBlank((CharSequence)channelOrgUpdateDto.getChannelOrgName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u6e20\u9053\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)channelOrgUpdateDto.getChannelOrgType(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u6e20\u9053\u7ec4\u7ec7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((channelOrgUpdateDto.getChannelOrgName().length() < 128 ? 1 : 0) != 0, (String)"\u6e20\u9053\u7ec4\u7ec7\u540d\u79f0\u4fe1\u606f\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    public void sendCreateEvent(List<ChannelOrgVo> channelOrgVos) {
        if (Objects.nonNull(this.channelOrgEventListeners)) {
            for (ChannelOrgEventListener listener : this.channelOrgEventListeners) {
                listener.onBatchCreate(channelOrgVos);
            }
        }
    }

    public void sendUpdateEvent(List<ChannelOrgVo> channelOrgVos) {
        if (Objects.nonNull(this.channelOrgEventListeners)) {
            for (ChannelOrgEventListener listener : this.channelOrgEventListeners) {
                listener.onBatchUpdate(channelOrgVos);
            }
        }
    }

    public void sendEnableEvent(List<ChannelOrgVo> channelOrgVos) {
        if (Objects.nonNull(this.channelOrgEventListeners)) {
            for (ChannelOrgEventListener listener : this.channelOrgEventListeners) {
                listener.onBatchEnable(channelOrgVos);
            }
        }
    }

    public void sendDisableEvent(List<ChannelOrgVo> channelOrgVos) {
        if (Objects.nonNull(this.channelOrgEventListeners)) {
            for (ChannelOrgEventListener listener : this.channelOrgEventListeners) {
                listener.onBatchDisable(channelOrgVos);
            }
        }
    }

    public void sendDeleteEvent(List<ChannelOrgVo> channelOrgVos) {
        if (Objects.nonNull(this.channelOrgEventListeners)) {
            for (ChannelOrgEventListener listener : this.channelOrgEventListeners) {
                listener.onBatchDelete(channelOrgVos);
            }
        }
    }
}

