/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.channel.org.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.mdm.business.channel.org.local.entity.ChannelOrg;
import com.biz.crm.mdm.business.channel.org.local.repository.ChannelOrgRepository;
import com.biz.crm.mdm.business.channel.org.local.service.helper.ChannelOrgServiceHelper;
import com.biz.crm.mdm.business.channel.org.sdk.dto.ChannelOrgCreateDto;
import com.biz.crm.mdm.business.channel.org.sdk.dto.ChannelOrgEventBatchDto;
import com.biz.crm.mdm.business.channel.org.sdk.dto.ChannelOrgEventDto;
import com.biz.crm.mdm.business.channel.org.sdk.dto.ChannelOrgEventUpdateDto;
import com.biz.crm.mdm.business.channel.org.sdk.dto.ChannelOrgPaginationDto;
import com.biz.crm.mdm.business.channel.org.sdk.dto.ChannelOrgUpdateDto;
import com.biz.crm.mdm.business.channel.org.sdk.event.ChannelOrgNebulaEventListener;
import com.biz.crm.mdm.business.channel.org.sdk.service.ChannelOrgVoService;
import com.biz.crm.mdm.business.channel.org.sdk.vo.ChannelOrgVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ChannelOrgVoServiceImpl
implements ChannelOrgVoService {
    @Autowired(required=false)
    private ChannelOrgRepository channelOrgRepository;
    @Autowired(required=false)
    private ChannelOrgServiceHelper helper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCode;
    @Autowired(required=false)
    private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    public Page<ChannelOrgVo> findByConditions(Pageable pageable, ChannelOrgPaginationDto channelOrgPaginationDto) {
        ChannelOrg one;
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        channelOrgPaginationDto = Optional.ofNullable(channelOrgPaginationDto).orElse(new ChannelOrgPaginationDto());
        channelOrgPaginationDto.setTenantCode(TenantUtils.getTenantCode());
        if (StringUtils.isNotEmpty((CharSequence)channelOrgPaginationDto.getUnderChannelOrgCode()) && (one = this.channelOrgRepository.findDetailsByCode(channelOrgPaginationDto.getUnderChannelOrgCode(), channelOrgPaginationDto.getTenantCode())) != null) {
            channelOrgPaginationDto.setUnderThisRuleCode(one.getRuleCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)channelOrgPaginationDto.getNotUnderChannelOrgCode()) && (one = this.channelOrgRepository.findDetailsByCode(channelOrgPaginationDto.getNotUnderChannelOrgCode(), channelOrgPaginationDto.getTenantCode())) != null) {
            channelOrgPaginationDto.setNotUnderThisRuleCode(one.getRuleCode());
        }
        List selectedCodeList = Optional.ofNullable(channelOrgPaginationDto.getSelectedCodeList()).orElse(new ArrayList());
        if (StringUtils.isNotEmpty((CharSequence)channelOrgPaginationDto.getSelectedCode())) {
            selectedCodeList.add(channelOrgPaginationDto.getSelectedCode());
        }
        if (!CollectionUtils.isEmpty((Collection)selectedCodeList)) {
            channelOrgPaginationDto.setSelectedCodeList(selectedCodeList);
        }
        return this.channelOrgRepository.findByConditions(pageable, channelOrgPaginationDto);
    }

    public ChannelOrgVo findDetailsById(String id) {
        ChannelOrg parent;
        if (!StringUtils.isNotEmpty((CharSequence)id)) {
            return null;
        }
        ChannelOrg one = this.channelOrgRepository.findDetailsById(id, TenantUtils.getTenantCode());
        if (one == null) {
            return null;
        }
        ChannelOrgVo respVo = (ChannelOrgVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)one, ChannelOrgVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (StringUtils.isNotEmpty((CharSequence)one.getParentCode()) && (parent = this.channelOrgRepository.findDetailsByCode(one.getParentCode(), TenantUtils.getTenantCode())) != null) {
            respVo.setParentName(parent.getChannelOrgName());
        }
        return respVo;
    }

    @Transactional
    public ChannelOrgVo create(ChannelOrgCreateDto channelOrgCreateDto) {
        return this.createForm(channelOrgCreateDto);
    }

    private ChannelOrgVo createForm(ChannelOrgCreateDto channelOrgCreateDto) {
        this.helper.createValidation(channelOrgCreateDto);
        if (StringUtils.isBlank((CharSequence)channelOrgCreateDto.getParentCode())) {
            channelOrgCreateDto.setParentCode(null);
        }
        ChannelOrg channelOrg = (ChannelOrg)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)channelOrgCreateDto, ChannelOrg.class, HashSet.class, ArrayList.class, new String[0]));
        channelOrg.setTenantCode(TenantUtils.getTenantCode());
        channelOrg.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        channelOrg.setEnableStatus(null != channelOrg.getEnableStatus() ? channelOrg.getEnableStatus() : EnableStatusEnum.ENABLE.getCode());
        if (StringUtils.isBlank((CharSequence)channelOrgCreateDto.getChannelOrgCode())) {
            channelOrg.setChannelOrgCode((String)this.generateCode.generateCode("CO", 1).get(0));
        }
        int levelNum = 1;
        if (StringUtils.isNotEmpty((CharSequence)channelOrgCreateDto.getParentCode())) {
            ChannelOrg parent = this.channelOrgRepository.findDetailsByCode(channelOrgCreateDto.getParentCode(), TenantUtils.getTenantCode());
            levelNum = parent.getLevelNum() + 1;
        }
        String ruleCode = this.getRuleCodeByParentCode(channelOrgCreateDto.getParentCode());
        channelOrg.setRuleCode(ruleCode);
        channelOrg.setLevelNum(levelNum);
        this.channelOrgRepository.save((Object)channelOrg);
        ChannelOrgVo channelOrgVo = (ChannelOrgVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)channelOrg, ChannelOrgVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.helper.sendCreateEvent(Collections.singletonList(channelOrgVo));
        ChannelOrgEventDto channelOrgEventDto = (ChannelOrgEventDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)channelOrg, ChannelOrgEventDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable nebulaEvent = ChannelOrgNebulaEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)channelOrgEventDto, ChannelOrgNebulaEventListener.class, (SerializableBiConsumer)nebulaEvent);
        return channelOrgVo;
    }

    private String getRuleCodeByParentCode(String parentCode) {
        String parentRuleCode = null;
        if (StringUtils.isNotEmpty((CharSequence)parentCode)) {
            ChannelOrg parent = this.channelOrgRepository.findDetailsByCode(parentCode, TenantUtils.getTenantCode());
            Validate.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u6e20\u9053\u7ec4\u7ec7\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            parentRuleCode = parent.getRuleCode();
        }
        List<ChannelOrg> childrenListByParentCode = this.channelOrgRepository.findChildrenListByParentCode(parentCode, TenantUtils.getTenantCode());
        ArrayList childrenDto = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(childrenListByParentCode, ChannelOrg.class, TreeDto.class, HashSet.class, ArrayList.class, new String[0]));
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        return treeRuleCodeStrategy.generate(3, parentRuleCode, (List)childrenDto);
    }

    @Transactional
    public ChannelOrgVo update(ChannelOrgUpdateDto channelOrgUpdateDto) {
        return this.updateForm(channelOrgUpdateDto);
    }

    private ChannelOrgVo updateForm(ChannelOrgUpdateDto channelOrgUpdateDto) {
        this.helper.updateValidation(channelOrgUpdateDto);
        if (StringUtils.isBlank((CharSequence)channelOrgUpdateDto.getParentCode())) {
            channelOrgUpdateDto.setParentCode(null);
        }
        ChannelOrg channelOrg = this.channelOrgRepository.findDetailsById(channelOrgUpdateDto.getId(), TenantUtils.getTenantCode());
        int levelNum = 1;
        if (StringUtils.isNotEmpty((CharSequence)channelOrgUpdateDto.getParentCode())) {
            ChannelOrg parent = this.channelOrgRepository.findDetailsByCode(channelOrgUpdateDto.getParentCode(), TenantUtils.getTenantCode());
            levelNum = parent.getLevelNum() + 1;
        }
        ChannelOrgEventDto oldChannelOrgEventDto = (ChannelOrgEventDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)channelOrg, ChannelOrgEventDto.class, HashSet.class, ArrayList.class, new String[0]);
        ChannelOrg channelOrgNew = (ChannelOrg)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)channelOrgUpdateDto, ChannelOrg.class, HashSet.class, ArrayList.class, new String[0]));
        this.channelOrgRepository.updateById((Object)channelOrgNew);
        if (StringUtils.isBlank((CharSequence)channelOrgUpdateDto.getParentCode())) {
            this.channelOrgRepository.setParentCodeNull(channelOrgUpdateDto.getId());
        }
        boolean updateRuleCode = false;
        String enableStatusChangeTo = "";
        if (!(channelOrg.getParentCode() == null ? "" : channelOrg.getParentCode()).equals(channelOrgUpdateDto.getParentCode() == null ? "" : channelOrgUpdateDto.getParentCode())) {
            updateRuleCode = true;
        }
        if (!channelOrg.getEnableStatus().equals(channelOrgUpdateDto.getEnableStatus())) {
            enableStatusChangeTo = channelOrgUpdateDto.getEnableStatus();
        }
        if (updateRuleCode) {
            String ruleCode = this.getRuleCodeByParentCode(channelOrgUpdateDto.getParentCode());
            this.updateCurAndChildrenRuleCode(channelOrgNew.getChannelOrgCode(), ruleCode, levelNum);
        }
        if (StringUtils.isNotEmpty((CharSequence)enableStatusChangeTo)) {
            if (EnableStatusEnum.ENABLE.getCode().equals(enableStatusChangeTo)) {
                this.enableBatch(Collections.singletonList(channelOrgNew.getId()));
            } else if (EnableStatusEnum.DISABLE.getCode().equals(enableStatusChangeTo)) {
                this.disableBatch(Collections.singletonList(channelOrgNew.getId()));
            } else {
                throw new IllegalArgumentException("\u542f\u7528\u72b6\u6001\u9519\u8bef");
            }
        }
        channelOrg = this.channelOrgRepository.findDetailsById(channelOrgUpdateDto.getId(), TenantUtils.getTenantCode());
        ChannelOrgVo channelOrgVo = (ChannelOrgVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)channelOrg, ChannelOrgVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.helper.sendUpdateEvent(Collections.singletonList(channelOrgVo));
        ChannelOrgEventDto newChannelOrgEventDto = (ChannelOrgEventDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)channelOrgUpdateDto, ChannelOrgEventDto.class, HashSet.class, ArrayList.class, new String[0]);
        ChannelOrgEventUpdateDto channelOrgEventUpdateDto = new ChannelOrgEventUpdateDto();
        channelOrgEventUpdateDto.setOldChannelOrgEventDto(oldChannelOrgEventDto);
        channelOrgEventUpdateDto.setNewChannelOrgEventDto(newChannelOrgEventDto);
        SerializableBiConsumer & Serializable nebulaEvent = ChannelOrgNebulaEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)channelOrgEventUpdateDto, ChannelOrgNebulaEventListener.class, (SerializableBiConsumer)nebulaEvent);
        return channelOrgVo;
    }

    private void updateCurAndChildrenRuleCode(String customerOrgCode, String ruleCode, int levelNum) {
        ChannelOrg channelOrg = this.channelOrgRepository.findDetailsByCode(customerOrgCode, TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)channelOrg), (String)(customerOrgCode + "\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01"), (Object[])new Object[0]);
        channelOrg.setRuleCode(ruleCode);
        channelOrg.setLevelNum(levelNum);
        this.channelOrgRepository.updateById((Object)channelOrg);
        List<ChannelOrg> childrenList = this.channelOrgRepository.findChildrenListByParentCode(customerOrgCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(childrenList)) {
            return;
        }
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        for (int i = 0; i < childrenList.size(); ++i) {
            this.updateCurAndChildrenRuleCode(childrenList.get(i).getChannelOrgCode(), ruleCode + treeRuleCodeStrategy.generateByNum(3, i + 1), levelNum + 1);
        }
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f53\u8fdb\u884c\u542f\u7528\u64cd\u4f5c\u65f6\uff0c\u4e1a\u52a1\u6280\u672f\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        List<ChannelOrg> channelOrgList = this.channelOrgRepository.findListByIds(ids, TenantUtils.getTenantCode()).stream().filter(x -> !EnableStatusEnum.ENABLE.getCode().equals(x.getEnableStatus())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(channelOrgList)) {
            return;
        }
        List collect = channelOrgList.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList());
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        Set parentRuleCodesExcludeSelf = treeRuleCodeStrategy.findParentRuleCodeByRuleCodesExcludeAnySelf(3, collect);
        if (!parentRuleCodesExcludeSelf.isEmpty()) {
            List parentList = this.channelOrgRepository.findListByRuleCodes(parentRuleCodesExcludeSelf, TenantUtils.getTenantCode()).stream().filter(customerOrg -> !EnableStatusEnum.ENABLE.getCode().equals(customerOrg.getEnableStatus()) && !ids.contains(customerOrg.getId())).collect(Collectors.toList());
            Validate.isTrue((boolean)CollectionUtils.isEmpty(parentList), (String)"\u5b58\u5728\u672a\u542f\u7528\u7684\u4e0a\u7ea7\u5c42\u7ea7\uff0c\u4e0d\u80fd\u542f\u7528\u5f53\u524d\u5c42\u7ea7", (Object[])new Object[0]);
        }
        channelOrgList.forEach(customerOrg -> customerOrg.setEnableStatus(EnableStatusEnum.ENABLE.getCode()));
        this.channelOrgRepository.updateEnableStatusByIds(channelOrgList.stream().map(UuidEntity::getId).collect(Collectors.toList()), EnableStatusEnum.ENABLE);
        ArrayList channelOrgVos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(channelOrgList, ChannelOrg.class, ChannelOrgVo.class, HashSet.class, ArrayList.class, new String[0]));
        this.helper.sendEnableEvent(channelOrgVos);
        ArrayList channelOrgEventDtoList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(channelOrgList, ChannelOrg.class, ChannelOrgEventDto.class, HashSet.class, ArrayList.class, new String[0]));
        ChannelOrgEventBatchDto channelOrgEventBatchDto = new ChannelOrgEventBatchDto();
        channelOrgEventBatchDto.setChannelOrgEventDtoList((List)channelOrgEventDtoList);
        SerializableBiConsumer & Serializable nebulaEvent = ChannelOrgNebulaEventListener::onEnableBatch;
        this.nebulaNetEventClient.publish((NebulaEventDto)channelOrgEventBatchDto, ChannelOrgNebulaEventListener.class, (SerializableBiConsumer)nebulaEvent);
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f53\u8fdb\u884c\u7981\u7528\u64cd\u4f5c\u65f6\uff0c\u4e1a\u52a1\u6280\u672f\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        List<ChannelOrg> channelOrgList = this.channelOrgRepository.findListByIds(ids, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(channelOrgList)) {
            return;
        }
        List<String> ruleCodes = channelOrgList.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList());
        List<ChannelOrg> childrenByRuleCodeList = this.channelOrgRepository.findCurAndChildrenByRuleCodeList(ruleCodes, EnableStatusEnum.ENABLE.getCode(), TenantUtils.getTenantCode());
        if (!CollectionUtils.isEmpty(childrenByRuleCodeList)) {
            childrenByRuleCodeList.forEach(customerOrg -> customerOrg.setEnableStatus(EnableStatusEnum.DISABLE.getCode()));
            this.channelOrgRepository.updateEnableStatusByIds(childrenByRuleCodeList.stream().map(UuidEntity::getId).collect(Collectors.toList()), EnableStatusEnum.DISABLE);
            ArrayList channelOrgVos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(childrenByRuleCodeList, ChannelOrg.class, ChannelOrgVo.class, HashSet.class, ArrayList.class, new String[0]));
            this.helper.sendDisableEvent(channelOrgVos);
            ArrayList channelOrgEventDtoList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(channelOrgList, ChannelOrg.class, ChannelOrgEventDto.class, HashSet.class, ArrayList.class, new String[0]));
            ChannelOrgEventBatchDto channelOrgEventBatchDto = new ChannelOrgEventBatchDto();
            channelOrgEventBatchDto.setChannelOrgEventDtoList((List)channelOrgEventDtoList);
            SerializableBiConsumer & Serializable nebulaEvent = ChannelOrgNebulaEventListener::onDisableBatch;
            this.nebulaNetEventClient.publish((NebulaEventDto)channelOrgEventBatchDto, ChannelOrgNebulaEventListener.class, (SerializableBiConsumer)nebulaEvent);
        }
    }

    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f53\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\u65f6\uff0c\u4e1a\u52a1\u6280\u672f\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        List<ChannelOrg> channelOrgs = this.channelOrgRepository.findListByIds(ids, TenantUtils.getTenantCode());
        Validate.isTrue((!CollectionUtils.isEmpty(channelOrgs) ? 1 : 0) != 0, (String)"\u65e0\u6548\u7684\u4e1a\u52a1\u6280\u672f\u7f16\u53f7\u4fe1\u606f", (Object[])new Object[0]);
        List<String> customerOrgCodeList = channelOrgs.stream().map(ChannelOrg::getChannelOrgCode).collect(Collectors.toList());
        List childrenList = this.channelOrgRepository.findChildrenListByParentCodes(customerOrgCodeList, TenantUtils.getTenantCode()).stream().filter(o -> !ids.contains(o.getId())).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(childrenList), (String)"\u5f53\u524d\u6e20\u9053\u7ec4\u7ec7\u5305\u542b\u5b50\u5c42\u7ea7\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u82e5\u9700\u8981\u5220\u9664\u8bf7\u5148\u5220\u9664\u5b50\u5c42\u7ea7", (Object[])new Object[0]);
        for (ChannelOrg channelOrg : channelOrgs) {
            channelOrg.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
        }
        this.channelOrgRepository.updateDelFlagByIds(channelOrgs.stream().map(UuidEntity::getId).collect(Collectors.toList()));
        for (ChannelOrg channelOrg : channelOrgs) {
            this.channelOrgRepository.setParentCodeAndRuleCodeNull(channelOrg.getId());
        }
        ArrayList channelOrgVos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(channelOrgs, ChannelOrg.class, ChannelOrgVo.class, HashSet.class, ArrayList.class, new String[0]));
        this.helper.sendDeleteEvent(channelOrgVos);
        ArrayList channelOrgEventDtoList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(channelOrgs, ChannelOrg.class, ChannelOrgEventDto.class, HashSet.class, ArrayList.class, new String[0]));
        ChannelOrgEventBatchDto channelOrgEventBatchDto = new ChannelOrgEventBatchDto();
        channelOrgEventBatchDto.setChannelOrgEventDtoList((List)channelOrgEventDtoList);
        SerializableBiConsumer & Serializable nebulaEvent = ChannelOrgNebulaEventListener::onDeleteBatch;
        this.nebulaNetEventClient.publish((NebulaEventDto)channelOrgEventBatchDto, ChannelOrgNebulaEventListener.class, (SerializableBiConsumer)nebulaEvent);
    }

    @Transactional
    public void updateRuleCode() {
        this.channelOrgRepository.updateOrphanParentCodeNull(TenantUtils.getTenantCode());
        List<ChannelOrg> topList = this.channelOrgRepository.findListWithoutParentCode(TenantUtils.getTenantCode());
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        for (int i = 0; i < topList.size(); ++i) {
            this.updateCurAndChildrenRuleCode(topList.get(i).getChannelOrgCode(), treeRuleCodeStrategy.generateByNum(3, i + 1), 1);
        }
    }

    public List<ChannelOrgVo> findAll() {
        List<ChannelOrg> all = this.channelOrgRepository.findAll(TenantUtils.getTenantCode());
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(all, ChannelOrg.class, ChannelOrgVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public List<ChannelOrgVo> findCurAndChildrenByOrgCodeList(List<String> orgCodes) {
        if (CollectionUtils.isEmpty(orgCodes)) {
            return new ArrayList<ChannelOrgVo>();
        }
        List<ChannelOrg> channelOrgs = this.channelOrgRepository.findCurAndChildrenByOrgCodeList(orgCodes, EnableStatusEnum.ENABLE.getCode(), TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(channelOrgs)) {
            return new ArrayList<ChannelOrgVo>();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(channelOrgs, ChannelOrg.class, ChannelOrgVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public List<ChannelOrgVo> findByChannelOrgCodes(List<String> channelOrgCodes) {
        if (CollectionUtils.isEmpty(channelOrgCodes)) {
            return new ArrayList<ChannelOrgVo>();
        }
        List<ChannelOrg> entities = this.channelOrgRepository.findByCustomerOrgCodes(channelOrgCodes);
        if (CollectionUtils.isEmpty(entities)) {
            return new ArrayList<ChannelOrgVo>();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(entities, ChannelOrg.class, ChannelOrgVo.class, HashSet.class, ArrayList.class, new String[0]));
    }
}

