package com.biz.crm.mdm.business.channel.org.relation.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.dto.ChannelOrgRelationTerminalDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.dto.ChannelOrgRelationTerminalPageDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.service.ChannelOrgRelationTerminalVoService;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.vo.ChannelOrgRelationTerminalVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 渠道组织关系控制器
 *
 * @author pengxi
 */
@Api(tags = "渠道组织关系：ChannelOrgRelationTerminalVo：渠道组织关系")
@Slf4j
@RestController
@RequestMapping("/v1/channelOrgRelation/channelOrgRelationTerminalVo")
public class ChannelOrgRelationTerminalVoController {

  @Autowired(required = false)
  private ChannelOrgRelationTerminalVoService channelOrgRelationTerminalVoService;

  /**
   * 多条件分页查询
   *
   * @return
   */
  @ApiOperation(value = "多条件分页查询", notes = "分页参数为page和size，page从0开始，size默认50;")
  @GetMapping("findByConditions")
  public Result<Page<ChannelOrgRelationTerminalVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      @ApiParam(name = "ChannelOrgRelationTerminalPageDto", value = "渠道组织关系Dto") ChannelOrgRelationTerminalPageDto pageDto) {
    try {
      Page<ChannelOrgRelationTerminalVo> result = this.channelOrgRelationTerminalVoService.findByConditions(pageable, pageDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 多条件分页查询
   *
   * @return
   */
  @ApiOperation(value = "多条件分页查询", notes = "分页参数为page和size，page从0开始，size默认50;")
  @PostMapping("findByConditionsStuPost")
  public Result<Page<ChannelOrgRelationTerminalVo>> findByConditionsStuPost(@RequestBody ChannelOrgRelationTerminalPageDto pageDto) {
    try {
      PageRequest pageRequest = PageRequest.of(pageDto.getPage(), pageDto.getSize());
      Page<ChannelOrgRelationTerminalVo> result = this.channelOrgRelationTerminalVoService.findByConditions(pageRequest, pageDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 按照实体中的（id）主键进行查询明细查询
   *
   * @param id 主键
   */
  @ApiOperation(value = "按照实体中的（id）主键进行查询明细查询")
  @GetMapping("/findDetailsById")
  public Result<ChannelOrgRelationTerminalVo> findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try {
      ChannelOrgRelationTerminalVo result = this.channelOrgRelationTerminalVoService.findDetailsById(id);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 绑定关系
   */
  @PostMapping(value = "bind")
  public Result<?> bind(@RequestBody ChannelOrgRelationTerminalDto relationDto) {
    try {
      this.channelOrgRelationTerminalVoService.bind(relationDto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除关系
   */
  @DeleteMapping(value = "deleteByIds")
  public Result<?> deleteByIds(@RequestParam("ids") List<String> ids) {
    try {
      this.channelOrgRelationTerminalVoService.deleteByIds(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
