package com.biz.crm.mdm.business.channel.org.relation.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.apache.ibatis.type.JdbcType;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 渠道组织关联门店实体类
 *
 * @author pengxi
 */
@Getter
@Setter
@ApiModel(value = "ChannelOrgRelationTerminal", description = "渠道组织关联门店实体类")
@TableName("mdm_channel_org_relation_terminal")
@Entity
@Table(name = "mdm_channel_org_relation_terminal", indexes = {
    @Index(name = "cort_idx1", columnList = "tenant_code"),
    @Index(name = "cort_idx2", columnList = "terminal_code"),
    @Index(name = "cort_idx3", columnList = "channel_org_code"),
    @Index(name = "cort_idx4", columnList = "channel_org_rule_code"),
})
@org.hibernate.annotations.Table(appliesTo = "mdm_channel_org_relation_terminal", comment = "渠道组织关联门店表")
public class ChannelOrgRelationTerminal extends TenantOpEntity {

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  @TableField(value = "terminal_code")
  @Column(name = "terminal_code", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT '终端编码'")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  @TableField(value = "terminal_name")
  @Column(name = "terminal_name", length = 128, columnDefinition = "varchar(64) COMMENT '终端名称'")
  private String terminalName;

  /**
   * 渠道组织编码
   */
  @ApiModelProperty("渠道组织编码")
  @TableField(value = "channel_org_code", jdbcType = JdbcType.VARCHAR)
  @Column(name = "channel_org_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '渠道组织编码'")
  private String channelOrgCode;

  /**
   * 渠道组织名称
   */
  @ApiModelProperty("渠道组织名称")
  @TableField(value = "channel_org_name", jdbcType = JdbcType.VARCHAR)
  @Column(name = "channel_org_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '渠道组织名称'")
  private String channelOrgName;

  /**
   * 渠道组织规则编码
   */
  @ApiModelProperty("渠道组织规则编码")
  @TableField(value = "channel_org_rule_code")
  @Column(name = "channel_org_rule_code", length = 200, columnDefinition = "VARCHAR(64) COMMENT '渠道组织规则编码'")
  private String channelOrgRuleCode;
}
