package com.biz.crm.mdm.business.channel.org.relation.local.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.channel.org.relation.local.entity.ChannelOrgRelationTerminal;
import com.biz.crm.mdm.business.channel.org.relation.local.repository.ChannelOrgRelationTerminalRepository;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.dto.ChannelOrgRelationTerminalDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.dto.ChannelOrgRelationTerminalPageDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.dto.RelationTerminalDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.event.ChannelOrgTerminalEventDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.event.ChannelOrgTerminalEventListener;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.event.ChannelOrgTerminalInfoEventDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.event.ChannelOrgTerminalInfoResultDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.event.RelationTerminalInfoEventListener;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.event.RelationTerminalInfoResultDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.service.ChannelOrgRelationTerminalVoService;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.vo.ChannelOrgRelationTerminalVo;
import com.biz.crm.mdm.business.channel.org.sdk.service.ChannelOrgVoService;
import com.biz.crm.mdm.business.channel.org.sdk.vo.ChannelOrgVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 渠道组织关联门店策略实现
 *
 * @author pengxi
 **/
@Service
public class ChannelOrgRelationTerminalVoServiceImpl implements ChannelOrgRelationTerminalVoService {

  @Autowired(required = false)
  private ChannelOrgRelationTerminalRepository terminalRepository;
  @Autowired(required = false)
  private ChannelOrgVoService channelOrgVoService;
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private NebulaNetEventClient nebulaNetEventClient;

  @Override
  public void bind(ChannelOrgRelationTerminalDto dto) {
    // 参数校验
    this.validation(dto);
    // 根据租户+渠道组织编码+终端编码集合查询历史关联
    List<ChannelOrgRelationTerminal> oldEntities = this.terminalRepository.findByTenantCodeAndChannelOrgCodeAndTerminalCodes(TenantUtils.getTenantCode(), dto.getChannelOrgCode(), dto.getTerminals().stream().map(RelationTerminalDto::getTerminalCode).distinct().collect(Collectors.toList()));
    List<String> oldTerminalCodes = Optional.ofNullable(oldEntities).orElse(Lists.newLinkedList()).stream().map(ChannelOrgRelationTerminal::getTerminalCode).distinct().collect(Collectors.toList());
    // 查询渠道组织
    List<ChannelOrgVo> channelOrgVos = this.channelOrgVoService.findByChannelOrgCodes(Collections.singletonList(dto.getChannelOrgCode()));
    Map<String, ChannelOrgVo> channelOrgVoMap = Optional.ofNullable(channelOrgVos).orElse(Lists.newLinkedList()).stream()
        .collect(Collectors.toMap(ChannelOrgVo::getChannelOrgCode, Function.identity()));
    // 新增关联
    List<ChannelOrgRelationTerminal> entities = new ArrayList<>(dto.getTerminals().size());
    dto.getTerminals().forEach(terminal -> {
      if (oldTerminalCodes.contains(terminal.getTerminalCode())) {
        // 已存在关联跳过
        return;
      }
      ChannelOrgRelationTerminal entity = new ChannelOrgRelationTerminal();
      entity.setTenantCode(TenantUtils.getTenantCode());
      entity.setChannelOrgCode(dto.getChannelOrgCode());
      entity.setTerminalCode(terminal.getTerminalCode());
      entity.setTerminalName(terminal.getTerminalName());
      ChannelOrgVo channelOrgVo = channelOrgVoMap.get(dto.getChannelOrgCode());
      if (null != channelOrgVo) {
        // 把规则编码存下来，以后数据量大时方便搜索
        entity.setChannelOrgName(channelOrgVo.getChannelOrgName());
        entity.setChannelOrgRuleCode(channelOrgVo.getRuleCode());
      }
      entities.add(entity);
    });
    this.terminalRepository.saveBatch(entities);
    //推送事件
    List<ChannelOrgTerminalInfoResultDto> terminalInfo = this.requestTerminalInfo(entities.stream().map(ChannelOrgRelationTerminal::getTerminalCode).collect(Collectors.toSet()));
    if (!CollectionUtils.isEmpty(terminalInfo)) {
      ChannelOrgTerminalEventDto channelOrgEmployeeEventDto = new ChannelOrgTerminalEventDto();
      channelOrgEmployeeEventDto.setChannelOrgCode(dto.getChannelOrgCode());
      channelOrgEmployeeEventDto.setTerminalVos(
          (List<ChannelOrgTerminalInfoEventDto>) this.nebulaToolkitService.copyCollectionByWhiteList(terminalInfo, ChannelOrgTerminalInfoResultDto.class, ChannelOrgTerminalInfoEventDto.class,
              HashSet.class,
              ArrayList.class));
      SerializableBiConsumer<ChannelOrgTerminalEventListener, ChannelOrgTerminalEventDto> onCreate = ChannelOrgTerminalEventListener::onCreate;
      this.nebulaNetEventClient.publish(channelOrgEmployeeEventDto, ChannelOrgTerminalEventListener.class, onCreate);
    }

  }

  @Override
  public void deleteByIds(List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return;
    }
    this.terminalRepository.deleteByIds(ids);
    //推送事件
    List<ChannelOrgRelationTerminal> relationTerminals = this.terminalRepository.findByIds(ids);
    if (!CollectionUtils.isEmpty(relationTerminals)) {
      ChannelOrgTerminalEventDto channelOrgEmployeeEventDto = new ChannelOrgTerminalEventDto();
      channelOrgEmployeeEventDto.setChannelOrgCode(relationTerminals.get(0).getChannelOrgCode());
      channelOrgEmployeeEventDto.setTerminalCodes(relationTerminals.stream().map(ChannelOrgRelationTerminal::getTerminalCode).collect(Collectors.toSet()));
      SerializableBiConsumer<ChannelOrgTerminalEventListener, ChannelOrgTerminalEventDto> onDelete = ChannelOrgTerminalEventListener::onDelete;
      this.nebulaNetEventClient.publish(channelOrgEmployeeEventDto, ChannelOrgTerminalEventListener.class, onDelete);
    }

  }

  @Override
  public ChannelOrgRelationTerminalVo findDetailsById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    ChannelOrgRelationTerminal entity = this.terminalRepository.getById(id);
    if (null == entity) {
      return null;
    }
    ChannelOrgRelationTerminalVo relationTerminalVo = this.nebulaToolkitService.copyObjectByWhiteList(entity, ChannelOrgRelationTerminalVo.class, HashSet.class, ArrayList.class);
    // 查询并完善页面要展示的字段
    List<ChannelOrgVo> channelOrgVos = this.channelOrgVoService.findByChannelOrgCodes(Collections.singletonList(relationTerminalVo.getChannelOrgCode()));
    if (CollectionUtils.isNotEmpty(channelOrgVos)) {
      this.buildCustomerOrgInfo(channelOrgVos.get(0), relationTerminalVo);
    }
    //通过事件查询数据
    List<ChannelOrgTerminalInfoResultDto> terminalInfo = this.requestTerminalInfo(Collections.singleton(relationTerminalVo.getTerminalCode()));
    if (CollectionUtils.isNotEmpty(terminalInfo)) {
      this.buildTerminalInfo(terminalInfo.get(0), relationTerminalVo);
    }
    return relationTerminalVo;
  }

  @Override
  public Page<ChannelOrgRelationTerminalVo> findByConditions(Pageable pageable, ChannelOrgRelationTerminalPageDto dto) {
    dto.setTenantCode(TenantUtils.getTenantCode());
    Page<ChannelOrgRelationTerminalVo> relationTerminalVoPage = this.terminalRepository.findByConditions(pageable, dto);
    List<ChannelOrgRelationTerminalVo> relationVos = relationTerminalVoPage.getRecords();
    if (CollectionUtils.isEmpty(relationVos)) {
      return new Page<>();
    }
    // 查询并完善页面要展示的字段
    List<String> channelOrgCodes = relationVos.stream().map(ChannelOrgRelationTerminalVo::getChannelOrgCode).distinct().collect(Collectors.toList());
    List<String> terminalCodes = relationVos.stream().map(ChannelOrgRelationTerminalVo::getTerminalCode).distinct().collect(Collectors.toList());
    List<ChannelOrgVo> channelOrgVos = this.channelOrgVoService.findByChannelOrgCodes(channelOrgCodes);
    // 把父级组织也查出来
    if (CollectionUtils.isNotEmpty(channelOrgVos)) {
      List<String> parentOrgCodes = channelOrgVos.stream()
          .filter(o -> StringUtils.isNotBlank(o.getParentCode()) && !channelOrgCodes.contains(o.getParentCode()))
          .map(ChannelOrgVo::getParentCode).distinct().collect(Collectors.toList());
      List<ChannelOrgVo> parentOrgVos = this.channelOrgVoService.findByChannelOrgCodes(parentOrgCodes);
      if (CollectionUtils.isNotEmpty(parentOrgVos)) {
        channelOrgVos.addAll(parentOrgVos);
      }
    }
    Map<String, ChannelOrgVo> channelOrgVoMap = Optional.ofNullable(channelOrgVos).orElse(Lists.newArrayList())
        .stream().collect(Collectors.toMap(ChannelOrgVo::getChannelOrgCode, Function.identity()));
    List<ChannelOrgTerminalInfoResultDto> infoResultDtos = this.requestTerminalInfo(Sets.newHashSet(terminalCodes));
    Map<String, ChannelOrgTerminalInfoResultDto> terminalVoMap = Optional.ofNullable(infoResultDtos).orElse(Lists.newArrayList())
        .stream().collect(Collectors.toMap(ChannelOrgTerminalInfoResultDto::getTerminalCode, Function.identity()));
    relationVos.forEach(vo -> {
      ChannelOrgVo channelOrgVo = channelOrgVoMap.get(vo.getChannelOrgCode());
      if (null != channelOrgVo) {
        this.buildCustomerOrgInfo(channelOrgVo, vo);
      }
      if (StringUtils.isNotBlank(vo.getParentChannelOrgCode())) {
        ChannelOrgVo parentOrgVo = channelOrgVoMap.get(vo.getParentChannelOrgCode());
        if (null != parentOrgVo) {
          vo.setParentChannelOrgName(parentOrgVo.getChannelOrgName());
        }
      }
      ChannelOrgTerminalInfoResultDto terminalVo = terminalVoMap.get(vo.getTerminalCode());
      if (null != terminalVo) {
        this.buildTerminalInfo(terminalVo, vo);
      }
    });
    relationTerminalVoPage.setRecords(relationVos);
    return relationTerminalVoPage;
  }

  @Override
  public List<String> findTerminalCodesByChannelOrgChannel(String channelOrgCode) {
    if (StringUtils.isBlank(channelOrgCode)) {
      return new ArrayList<>(0);
    }
    List<ChannelOrgRelationTerminal> terminals = this.terminalRepository.findByChannelOrgCode(channelOrgCode);
    if (CollectionUtils.isEmpty(terminals)) {
      return new ArrayList<>(0);
    }
    return terminals.stream().map(ChannelOrgRelationTerminal::getTerminalCode).collect(Collectors.toList());
  }

  private void buildCustomerOrgInfo(ChannelOrgVo channelOrgVo, ChannelOrgRelationTerminalVo vo) {
    vo.setChannelOrgLevel(channelOrgVo.getChannelOrgLevel());
    vo.setChannelOrgType(channelOrgVo.getChannelOrgType());
    vo.setChannelOrgName(channelOrgVo.getChannelOrgName());
    vo.setChannelOrgDesc(channelOrgVo.getChannelOrgDesc());
    vo.setParentChannelOrgCode(channelOrgVo.getParentCode());
    vo.setParentChannelOrgName(channelOrgVo.getParentName());
    vo.setChannelOrgLevelNum(channelOrgVo.getLevelNum());
  }

  private void buildTerminalInfo(ChannelOrgTerminalInfoResultDto terminalVo, ChannelOrgRelationTerminalVo vo) {
    vo.setTerminalName(terminalVo.getTerminalName());
    vo.setChannel(terminalVo.getChannel());
    vo.setProvinceCode(terminalVo.getProvinceCode());
    vo.setProvinceName(terminalVo.getProvinceName());
    vo.setCityCode(terminalVo.getCityCode());
    vo.setCityName(terminalVo.getCityName());
    vo.setDistrictCode(terminalVo.getDistrictCode());
    vo.setDistrictName(terminalVo.getDistrictName());
    vo.setTerminalAddress(terminalVo.getTerminalAddress());
  }

  private void validation(ChannelOrgRelationTerminalDto dto) {
    Validate.notNull(dto, "关联对象不能为空！");
    Validate.notBlank(dto.getChannelOrgCode(), "渠道组织编码不能为空！");
    Validate.notEmpty(dto.getTerminals(), "终端集合不能为空！");
    dto.getTerminals().forEach(terminal -> {
      Validate.notBlank(terminal.getTerminalCode(), "终端编码不能为空！");
      //Validate.notBlank(terminal.getTerminalName(), "终端名称不能为空！");
    });
  }

  /**
   * 通过事件请求数据
   */
  private List<ChannelOrgTerminalInfoResultDto> requestTerminalInfo(Set<String> terminalCodes) {
    //推送事件
    ChannelOrgTerminalEventDto eventDto = new ChannelOrgTerminalEventDto();
    eventDto.setTerminalCodes(terminalCodes);
    SerializableBiConsumer<RelationTerminalInfoEventListener, ChannelOrgTerminalEventDto> onFindByTerminalCodes = RelationTerminalInfoEventListener::onFindByTerminalCodes;
    RelationTerminalInfoResultDto eventResponse = (RelationTerminalInfoResultDto) this.nebulaNetEventClient.directPublish(eventDto, RelationTerminalInfoEventListener.class, onFindByTerminalCodes);
    if (eventResponse == null || CollectionUtils.isEmpty(eventResponse.getResultDtos())) {
      return null;
    }
    return eventResponse.getResultDtos();
  }
}
