package com.biz.crm.mdm.business.channel.org.relation.local.internal;

import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.model.ChannelOrgRelationModel;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.register.ChannelOrgRelationRegister;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.service.ChannelOrgRelationVoService;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 渠道组织关联门店服务实现
 *
 * @author pengxi
 **/
@Service
public class ChannelOrgRelationVoServiceImpl implements ChannelOrgRelationVoService {
  @Autowired(required = false)
  private List<ChannelOrgRelationRegister> channelOrgRelationRegisters;

  @Override
  public List<ChannelOrgRelationModel> findChannelOrgRelationModel() {
    if (CollectionUtils.isEmpty(channelOrgRelationRegisters)) {
      return new ArrayList<>();
    }
    List<ChannelOrgRelationModel> models = Lists.newArrayList();
    for (ChannelOrgRelationRegister register : channelOrgRelationRegisters) {
      ChannelOrgRelationModel ChannelOrgRelationModel = new ChannelOrgRelationModel();
      ChannelOrgRelationModel.setKey(register.getKey());
      ChannelOrgRelationModel.setName(register.getName());
      models.add(ChannelOrgRelationModel);
    }
    return models;
  }

}
