package com.biz.crm.mdm.business.channel.org.relation.local.strategy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.mdm.business.channel.org.relation.local.register.ChannelOrgRelationTerminalRegister;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.event.ChannelOrgTerminalEventDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.event.ChannelOrgTerminalInfoEventDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.event.ChannelOrgTerminalInfoResultDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.event.RelationTerminalInfoEventListener;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.event.RelationTerminalInfoResultDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.service.ChannelOrgRelationTerminalVoService;
import com.biz.crm.mdm.business.channel.org.sdk.strategy.ChannelOrgRelationStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 渠道组织关联门店策略实现类
 */
@Component
public class ChannelOrgRelationTerminalStrategy implements ChannelOrgRelationStrategy {

  @Autowired(required = false)
  private ChannelOrgRelationTerminalRegister channelOrgRelationTerminalRegister;
  @Autowired(required = false)
  private ChannelOrgRelationTerminalVoService channelOrgRelationTerminalVoService;
  @Autowired(required = false)
  private NebulaNetEventClient nebulaNetEventClient;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public String getKey() {
    return this.channelOrgRelationTerminalRegister.getKey();
  }

  @Override
  public JSONArray findByChannelOrgChannel(String channelOrgCode) {
    if (StringUtils.isBlank(channelOrgCode)) {
      return null;
    }
    List<String> terminalCodes = channelOrgRelationTerminalVoService.findTerminalCodesByChannelOrgChannel(channelOrgCode);
    if (CollectionUtils.isEmpty(terminalCodes)) {
      return null;
    }
    List<ChannelOrgTerminalInfoResultDto> resultDtos = this.requestTerminalInfo(Sets.newHashSet(terminalCodes));
    if (CollectionUtils.isEmpty(resultDtos)) {
      return null;
    }
    List<ChannelOrgTerminalInfoEventDto> channelOrgTerminalInfoEventDtos = (List<ChannelOrgTerminalInfoEventDto>) this.nebulaToolkitService.copyCollectionByWhiteList(resultDtos,
        ChannelOrgTerminalInfoResultDto.class,
        ChannelOrgTerminalInfoEventDto.class, HashSet.class,
        ArrayList.class);
    return JSON.parseArray(JSON.toJSONString(channelOrgTerminalInfoEventDtos));
  }

  /**
   * 通过事件请求数据
   */
  private List<ChannelOrgTerminalInfoResultDto> requestTerminalInfo(Set<String> terminalCodes) {
    //推送事件
    ChannelOrgTerminalEventDto eventDto = new ChannelOrgTerminalEventDto();
    eventDto.setTerminalCodes(terminalCodes);
    SerializableBiConsumer<RelationTerminalInfoEventListener, ChannelOrgTerminalEventDto> onFindByTerminalCodes = RelationTerminalInfoEventListener::onFindByTerminalCodes;
    RelationTerminalInfoResultDto eventResponse = (RelationTerminalInfoResultDto) this.nebulaNetEventClient.directPublish(eventDto, RelationTerminalInfoEventListener.class, onFindByTerminalCodes);
    if (eventResponse == null || CollectionUtils.isEmpty(eventResponse.getResultDtos())) {
      return null;
    }
    return eventResponse.getResultDtos();
  }
}
