/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.channel.org.relation.local.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.channel.org.relation.local.entity.ChannelOrgRelationTerminal;
import com.biz.crm.mdm.business.channel.org.relation.local.repository.ChannelOrgRelationTerminalRepository;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.dto.ChannelOrgRelationTerminalDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.dto.ChannelOrgRelationTerminalPageDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.dto.RelationTerminalDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.event.ChannelOrgTerminalEventDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.event.ChannelOrgTerminalEventListener;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.event.ChannelOrgTerminalInfoEventDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.event.ChannelOrgTerminalInfoResultDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.event.RelationTerminalInfoEventListener;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.event.RelationTerminalInfoResultDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.service.ChannelOrgRelationTerminalVoService;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.vo.AbstractChannelOrgRelationVo;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.vo.ChannelOrgRelationTerminalVo;
import com.biz.crm.mdm.business.channel.org.sdk.service.ChannelOrgVoService;
import com.biz.crm.mdm.business.channel.org.sdk.vo.ChannelOrgVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ChannelOrgRelationTerminalVoServiceImpl
implements ChannelOrgRelationTerminalVoService {
    @Autowired(required=false)
    private ChannelOrgRelationTerminalRepository terminalRepository;
    @Autowired(required=false)
    private ChannelOrgVoService channelOrgVoService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    public void bind(ChannelOrgRelationTerminalDto dto) {
        this.validation(dto);
        List<ChannelOrgRelationTerminal> oldEntities = this.terminalRepository.findByTenantCodeAndChannelOrgCodeAndTerminalCodes(TenantUtils.getTenantCode(), dto.getChannelOrgCode(), dto.getTerminals().stream().map(RelationTerminalDto::getTerminalCode).distinct().collect(Collectors.toList()));
        List oldTerminalCodes = Optional.ofNullable(oldEntities).orElse(Lists.newLinkedList()).stream().map(ChannelOrgRelationTerminal::getTerminalCode).distinct().collect(Collectors.toList());
        List channelOrgVos = this.channelOrgVoService.findByChannelOrgCodes(Collections.singletonList(dto.getChannelOrgCode()));
        Map channelOrgVoMap = Optional.ofNullable(channelOrgVos).orElse(Lists.newLinkedList()).stream().collect(Collectors.toMap(ChannelOrgVo::getChannelOrgCode, Function.identity()));
        ArrayList entities = new ArrayList(dto.getTerminals().size());
        dto.getTerminals().forEach(terminal -> {
            if (oldTerminalCodes.contains(terminal.getTerminalCode())) {
                return;
            }
            ChannelOrgRelationTerminal entity = new ChannelOrgRelationTerminal();
            entity.setTenantCode(TenantUtils.getTenantCode());
            entity.setChannelOrgCode(dto.getChannelOrgCode());
            entity.setTerminalCode(terminal.getTerminalCode());
            entity.setTerminalName(terminal.getTerminalName());
            ChannelOrgVo channelOrgVo = (ChannelOrgVo)channelOrgVoMap.get(dto.getChannelOrgCode());
            if (null != channelOrgVo) {
                entity.setChannelOrgName(channelOrgVo.getChannelOrgName());
                entity.setChannelOrgRuleCode(channelOrgVo.getRuleCode());
            }
            entities.add(entity);
        });
        this.terminalRepository.saveBatch(entities);
        List<ChannelOrgTerminalInfoResultDto> terminalInfo = this.requestTerminalInfo(entities.stream().map(ChannelOrgRelationTerminal::getTerminalCode).collect(Collectors.toSet()));
        if (!CollectionUtils.isEmpty(terminalInfo)) {
            ChannelOrgTerminalEventDto channelOrgEmployeeEventDto = new ChannelOrgTerminalEventDto();
            channelOrgEmployeeEventDto.setChannelOrgCode(dto.getChannelOrgCode());
            channelOrgEmployeeEventDto.setTerminalVos((List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalInfo, ChannelOrgTerminalInfoResultDto.class, ChannelOrgTerminalInfoEventDto.class, HashSet.class, ArrayList.class, new String[0]));
            SerializableBiConsumer & Serializable onCreate = ChannelOrgTerminalEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)channelOrgEmployeeEventDto, ChannelOrgTerminalEventListener.class, (SerializableBiConsumer)onCreate);
        }
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.terminalRepository.deleteByIds(ids);
        List<ChannelOrgRelationTerminal> relationTerminals = this.terminalRepository.findByIds(ids);
        if (!CollectionUtils.isEmpty(relationTerminals)) {
            ChannelOrgTerminalEventDto channelOrgEmployeeEventDto = new ChannelOrgTerminalEventDto();
            channelOrgEmployeeEventDto.setChannelOrgCode(relationTerminals.get(0).getChannelOrgCode());
            channelOrgEmployeeEventDto.setTerminalCodes(relationTerminals.stream().map(ChannelOrgRelationTerminal::getTerminalCode).collect(Collectors.toSet()));
            SerializableBiConsumer & Serializable onDelete = ChannelOrgTerminalEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)channelOrgEmployeeEventDto, ChannelOrgTerminalEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    public ChannelOrgRelationTerminalVo findDetailsById(String id) {
        List<ChannelOrgTerminalInfoResultDto> terminalInfo;
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ChannelOrgRelationTerminal entity = (ChannelOrgRelationTerminal)((Object)this.terminalRepository.getById((Serializable)((Object)id)));
        if (null == entity) {
            return null;
        }
        ChannelOrgRelationTerminalVo relationTerminalVo = (ChannelOrgRelationTerminalVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ChannelOrgRelationTerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        List channelOrgVos = this.channelOrgVoService.findByChannelOrgCodes(Collections.singletonList(relationTerminalVo.getChannelOrgCode()));
        if (CollectionUtils.isNotEmpty((Collection)channelOrgVos)) {
            this.buildCustomerOrgInfo((ChannelOrgVo)channelOrgVos.get(0), relationTerminalVo);
        }
        if (CollectionUtils.isNotEmpty(terminalInfo = this.requestTerminalInfo(Collections.singleton(relationTerminalVo.getTerminalCode())))) {
            this.buildTerminalInfo(terminalInfo.get(0), relationTerminalVo);
        }
        return relationTerminalVo;
    }

    public Page<ChannelOrgRelationTerminalVo> findByConditions(Pageable pageable, ChannelOrgRelationTerminalPageDto dto) {
        List parentOrgCodes;
        List parentOrgVos;
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<ChannelOrgRelationTerminalVo> relationTerminalVoPage = this.terminalRepository.findByConditions(pageable, dto);
        List relationVos = relationTerminalVoPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)relationVos)) {
            return new Page();
        }
        List channelOrgCodes = relationVos.stream().map(AbstractChannelOrgRelationVo::getChannelOrgCode).distinct().collect(Collectors.toList());
        List terminalCodes = relationVos.stream().map(ChannelOrgRelationTerminalVo::getTerminalCode).distinct().collect(Collectors.toList());
        List channelOrgVos = this.channelOrgVoService.findByChannelOrgCodes(channelOrgCodes);
        if (CollectionUtils.isNotEmpty((Collection)channelOrgVos) && CollectionUtils.isNotEmpty((Collection)(parentOrgVos = this.channelOrgVoService.findByChannelOrgCodes(parentOrgCodes = channelOrgVos.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getParentCode()) && !channelOrgCodes.contains(o.getParentCode())).map(ChannelOrgVo::getParentCode).distinct().collect(Collectors.toList()))))) {
            channelOrgVos.addAll(parentOrgVos);
        }
        Map channelOrgVoMap = Optional.ofNullable(channelOrgVos).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(ChannelOrgVo::getChannelOrgCode, Function.identity()));
        List<ChannelOrgTerminalInfoResultDto> infoResultDtos = this.requestTerminalInfo(Sets.newHashSet(terminalCodes));
        Map terminalVoMap = Optional.ofNullable(infoResultDtos).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(ChannelOrgTerminalInfoResultDto::getTerminalCode, Function.identity()));
        relationVos.forEach(vo -> {
            ChannelOrgTerminalInfoResultDto terminalVo;
            ChannelOrgVo parentOrgVo;
            ChannelOrgVo channelOrgVo = (ChannelOrgVo)channelOrgVoMap.get(vo.getChannelOrgCode());
            if (null != channelOrgVo) {
                this.buildCustomerOrgInfo(channelOrgVo, (ChannelOrgRelationTerminalVo)vo);
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getParentChannelOrgCode()) && null != (parentOrgVo = (ChannelOrgVo)channelOrgVoMap.get(vo.getParentChannelOrgCode()))) {
                vo.setParentChannelOrgName(parentOrgVo.getChannelOrgName());
            }
            if (null != (terminalVo = (ChannelOrgTerminalInfoResultDto)terminalVoMap.get(vo.getTerminalCode()))) {
                this.buildTerminalInfo(terminalVo, (ChannelOrgRelationTerminalVo)vo);
            }
        });
        relationTerminalVoPage.setRecords(relationVos);
        return relationTerminalVoPage;
    }

    public List<String> findTerminalCodesByChannelOrgChannel(String channelOrgCode) {
        if (StringUtils.isBlank((CharSequence)channelOrgCode)) {
            return new ArrayList<String>(0);
        }
        List<ChannelOrgRelationTerminal> terminals = this.terminalRepository.findByChannelOrgCode(channelOrgCode);
        if (CollectionUtils.isEmpty(terminals)) {
            return new ArrayList<String>(0);
        }
        return terminals.stream().map(ChannelOrgRelationTerminal::getTerminalCode).collect(Collectors.toList());
    }

    private void buildCustomerOrgInfo(ChannelOrgVo channelOrgVo, ChannelOrgRelationTerminalVo vo) {
        vo.setChannelOrgLevel(channelOrgVo.getChannelOrgLevel());
        vo.setChannelOrgType(channelOrgVo.getChannelOrgType());
        vo.setChannelOrgName(channelOrgVo.getChannelOrgName());
        vo.setChannelOrgDesc(channelOrgVo.getChannelOrgDesc());
        vo.setParentChannelOrgCode(channelOrgVo.getParentCode());
        vo.setParentChannelOrgName(channelOrgVo.getParentName());
        vo.setChannelOrgLevelNum(channelOrgVo.getLevelNum());
    }

    private void buildTerminalInfo(ChannelOrgTerminalInfoResultDto terminalVo, ChannelOrgRelationTerminalVo vo) {
        vo.setTerminalName(terminalVo.getTerminalName());
        vo.setChannel(terminalVo.getChannel());
        vo.setProvinceCode(terminalVo.getProvinceCode());
        vo.setProvinceName(terminalVo.getProvinceName());
        vo.setCityCode(terminalVo.getCityCode());
        vo.setCityName(terminalVo.getCityName());
        vo.setDistrictCode(terminalVo.getDistrictCode());
        vo.setDistrictName(terminalVo.getDistrictName());
        vo.setTerminalAddress(terminalVo.getTerminalAddress());
    }

    private void validation(ChannelOrgRelationTerminalDto dto) {
        Validate.notNull((Object)dto, (String)"\u5173\u8054\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getChannelOrgCode(), (String)"\u6e20\u9053\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)dto.getTerminals(), (String)"\u7ec8\u7aef\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.getTerminals().forEach(terminal -> Validate.notBlank((CharSequence)terminal.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]));
    }

    private List<ChannelOrgTerminalInfoResultDto> requestTerminalInfo(Set<String> terminalCodes) {
        ChannelOrgTerminalEventDto eventDto = new ChannelOrgTerminalEventDto();
        eventDto.setTerminalCodes(terminalCodes);
        SerializableBiConsumer & Serializable onFindByTerminalCodes = RelationTerminalInfoEventListener::onFindByTerminalCodes;
        RelationTerminalInfoResultDto eventResponse = (RelationTerminalInfoResultDto)this.nebulaNetEventClient.directPublish((NebulaEventDto)eventDto, RelationTerminalInfoEventListener.class, (SerializableBiConsumer)onFindByTerminalCodes);
        if (eventResponse == null || CollectionUtils.isEmpty((Collection)eventResponse.getResultDtos())) {
            return null;
        }
        return eventResponse.getResultDtos();
    }
}

