package com.biz.crm.mdm.business.channel.org.relation.local.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.channel.org.relation.local.entity.ChannelOrgRelationTerminal;
import com.biz.crm.mdm.business.channel.org.relation.local.repository.ChannelOrgRelationTerminalRepository;
import com.biz.crm.mdm.business.channel.org.sdk.service.ChannelOrgVoService;
import com.biz.crm.mdm.business.channel.org.sdk.vo.ChannelOrgVo;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.dto.ChannelOrgRelationTerminalDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.dto.ChannelOrgRelationTerminalPageDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.dto.RelationTerminalDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.register.ChannelOrgRelationRegister;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.service.ChannelOrgRelationTerminalVoService;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.vo.ChannelOrgRelationTerminalVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 渠道组织关联门店策略实现
 *
 * @author pengxi
 **/
@Service
public class ChannelOrgRelationTerminalVoServiceImpl implements ChannelOrgRelationRegister, ChannelOrgRelationTerminalVoService {
  @Autowired(required = false)
  private ChannelOrgRelationTerminalRepository terminalRepository;
  @Autowired(required = false)
  private ChannelOrgVoService channelOrgVoService;
  @Autowired(required = false)
  private TerminalVoService terminalVoService;
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public String getName() {
    return "门店";
  }

  @Override
  public String getKey() {
    return "terminal";
  }

  @Override
  public void bind(ChannelOrgRelationTerminalDto dto) {
    // 参数校验
    this.validation(dto);
    // 根据租户+渠道组织编码+终端编码集合查询历史关联
    List<ChannelOrgRelationTerminal> oldEntities = this.terminalRepository.findByTenantCodeAndChannelOrgCodeAndTerminalCodes(TenantUtils.getTenantCode(), dto.getChannelOrgCode(), dto.getTerminals().stream().map(RelationTerminalDto::getTerminalCode).distinct().collect(Collectors.toList()));
    List<String> oldTerminalCodes = Optional.ofNullable(oldEntities).orElse(Lists.newLinkedList()).stream().map(ChannelOrgRelationTerminal::getTerminalCode).distinct().collect(Collectors.toList());
    // 查询渠道组织
    List<ChannelOrgVo> channelOrgVos = this.channelOrgVoService.findByChannelOrgCodes(Collections.singletonList(dto.getChannelOrgCode()));
    Map<String, ChannelOrgVo> channelOrgVoMap = Optional.ofNullable(channelOrgVos).orElse(Lists.newLinkedList()).stream().collect(Collectors.toMap(ChannelOrgVo::getChannelOrgCode, Function.identity()));
    // 新增关联
    List<ChannelOrgRelationTerminal> entities = new ArrayList<>(dto.getTerminals().size());
    dto.getTerminals().forEach(terminal->{
      if (oldTerminalCodes.contains(terminal.getTerminalCode())) {
        // 已存在关联跳过
        return;
      }
      ChannelOrgRelationTerminal entity = new ChannelOrgRelationTerminal();
      entity.setTenantCode(TenantUtils.getTenantCode());
      entity.setChannelOrgCode(dto.getChannelOrgCode());
      entity.setTerminalCode(terminal.getTerminalCode());
      entity.setTerminalName(terminal.getTerminalName());
      ChannelOrgVo channelOrgVo = channelOrgVoMap.get(dto.getChannelOrgCode());
      if (null != channelOrgVo) {
        // 把规则编码存下来，以后数据量大时方便搜索
        entity.setChannelOrgName(channelOrgVo.getChannelOrgName());
        entity.setChannelOrgRuleCode(channelOrgVo.getRuleCode());
      }
      entities.add(entity);
    });
    this.terminalRepository.saveBatch(entities);
  }

  @Override
  public void deleteByIds(List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return;
    }
    this.terminalRepository.deleteByIds(ids);
  }

  @Override
  public ChannelOrgRelationTerminalVo findDetailsById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    ChannelOrgRelationTerminal entity = this.terminalRepository.getById(id);
    if (null == entity) {
      return null;
    }
    ChannelOrgRelationTerminalVo relationTerminalVo = this.nebulaToolkitService.copyObjectByWhiteList(entity, ChannelOrgRelationTerminalVo.class, HashSet.class, ArrayList.class);
    // 查询并完善页面要展示的字段
    List<ChannelOrgVo> channelOrgVos = this.channelOrgVoService.findByChannelOrgCodes(Collections.singletonList(relationTerminalVo.getChannelOrgCode()));
    if (CollectionUtils.isNotEmpty(channelOrgVos)) {
      this.buildCustomerOrgInfo(channelOrgVos.get(0), relationTerminalVo);
    }
    List<TerminalVo> terminalVos = this.terminalVoService.findTerminalAndContactByTerminalCodes(Collections.singletonList(relationTerminalVo.getTerminalCode()));
    if (CollectionUtils.isNotEmpty(terminalVos)) {
      this.buildTerminalInfo(terminalVos.get(0), relationTerminalVo);
    }
    return relationTerminalVo;
  }

  @Override
  public Page<ChannelOrgRelationTerminalVo> findByConditions(Pageable pageable, ChannelOrgRelationTerminalPageDto dto) {
    dto.setTenantCode(TenantUtils.getTenantCode());
    Page<ChannelOrgRelationTerminalVo> relationTerminalVoPage = this.terminalRepository.findByConditions(pageable, dto);
    List<ChannelOrgRelationTerminalVo> relationVos = relationTerminalVoPage.getRecords();
    if (CollectionUtils.isEmpty(relationVos)) {
      return new Page<>();
    }
    // 查询并完善页面要展示的字段
    List<String> channelOrgCodes = relationVos.stream().map(ChannelOrgRelationTerminalVo::getChannelOrgCode).distinct().collect(Collectors.toList());
    List<String> terminalCodes = relationVos.stream().map(ChannelOrgRelationTerminalVo::getTerminalCode).distinct().collect(Collectors.toList());
    List<ChannelOrgVo> channelOrgVos = this.channelOrgVoService.findByChannelOrgCodes(channelOrgCodes);
    // 把父级组织也查出来
    if (CollectionUtils.isNotEmpty(channelOrgVos)) {
      List<String> parentOrgCodes = channelOrgVos.stream()
              .filter(o->StringUtils.isNotBlank(o.getParentCode()) && !channelOrgCodes.contains(o.getParentCode()))
              .map(ChannelOrgVo::getParentCode).distinct().collect(Collectors.toList());
      List<ChannelOrgVo> parentOrgVos = this.channelOrgVoService.findByChannelOrgCodes(parentOrgCodes);
      if (CollectionUtils.isNotEmpty(parentOrgVos)) {
        channelOrgVos.addAll(parentOrgVos);
      }
    }
    Map<String, ChannelOrgVo> channelOrgVoMap = Optional.ofNullable(channelOrgVos).orElse(Lists.newArrayList())
            .stream().collect(Collectors.toMap(ChannelOrgVo::getChannelOrgCode, Function.identity()));
    List<TerminalVo> terminalVos = this.terminalVoService.findTerminalAndContactByTerminalCodes(terminalCodes);
    Map<String, TerminalVo> terminalVoMap = Optional.ofNullable(terminalVos).orElse(Lists.newArrayList())
            .stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity()));
    relationVos.forEach(vo->{
      ChannelOrgVo channelOrgVo = channelOrgVoMap.get(vo.getChannelOrgCode());
      if (null != channelOrgVo) {
        this.buildCustomerOrgInfo(channelOrgVo, vo);
      }
      if (StringUtils.isNotBlank(vo.getParentChannelOrgCode())) {
        ChannelOrgVo parentOrgVo = channelOrgVoMap.get(vo.getParentChannelOrgCode());
        if (null != parentOrgVo) {
          vo.setParentChannelOrgName(parentOrgVo.getChannelOrgName());
        }
      }
      TerminalVo terminalVo = terminalVoMap.get(vo.getTerminalCode());
      if (null != terminalVo) {
        this.buildTerminalInfo(terminalVo, vo);
      }
    });
    relationTerminalVoPage.setRecords(relationVos);
    return relationTerminalVoPage;
  }

  private void buildCustomerOrgInfo(ChannelOrgVo channelOrgVo, ChannelOrgRelationTerminalVo vo){
    vo.setChannelOrgLevel(channelOrgVo.getChannelOrgLevel());
    vo.setChannelOrgType(channelOrgVo.getChannelOrgType());
    vo.setChannelOrgName(channelOrgVo.getChannelOrgName());
    vo.setChannelOrgDesc(channelOrgVo.getChannelOrgDesc());
    vo.setParentChannelOrgCode(channelOrgVo.getParentCode());
    vo.setParentChannelOrgName(channelOrgVo.getParentName());
    vo.setChannelOrgLevelNum(channelOrgVo.getLevelNum());
  }

  private void buildTerminalInfo(TerminalVo terminalVo, ChannelOrgRelationTerminalVo vo){
    vo.setTerminalName(terminalVo.getTerminalName());
    vo.setTerminalType(terminalVo.getTerminalType());
    vo.setAmapId(terminalVo.getAmapId());
    vo.setChannel(terminalVo.getChannel());
    vo.setProvinceCode(terminalVo.getProvinceCode());
    vo.setProvinceName(terminalVo.getProvinceName());
    vo.setCityCode(terminalVo.getCityCode());
    vo.setCityName(terminalVo.getCityName());
    vo.setDistrictCode(terminalVo.getDistrictCode());
    vo.setDistrictName(terminalVo.getDistrictName());
    vo.setTerminalAddress(terminalVo.getTerminalAddress());
  }

  private void validation(ChannelOrgRelationTerminalDto dto) {
    Validate.notNull(dto, "关联对象不能为空！");
    Validate.notBlank(dto.getChannelOrgCode(), "渠道组织编码不能为空！");
    Validate.notEmpty(dto.getTerminals(), "终端集合不能为空！");
    dto.getTerminals().forEach(terminal->{
      Validate.notBlank(terminal.getTerminalCode(), "终端编码不能为空！");
      //Validate.notBlank(terminal.getTerminalName(), "终端名称不能为空！");
    });
  }
}
