package com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.event;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 终端信息事件vo
 *
 * @author sunx
 * @since 2021-10-19 13:53:15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "终端信息事件vo")
public class ChannelOrgTerminalInfoResultDto {

  private static final long serialVersionUID = 4156812499833240753L;


  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  private String terminalName;

  /**
   * 一级渠道
   */
  @ApiModelProperty("一级渠道")
  private String channel;

  /**
   * 二级渠道
   */
  @ApiModelProperty("二级渠道")
  private String twoChannel;

  /**
   * 终端地址
   */
  @ApiModelProperty("终端地址")
  private String terminalAddress;

  /**
   * 省
   */
  @ApiModelProperty("省")
  private String provinceCode;

  @ApiModelProperty("省名称")
  private String provinceName;

  /**
   * 市
   */
  @ApiModelProperty("市")
  private String cityCode;

  @ApiModelProperty("市名称")
  private String cityName;

  /**
   * 区
   */
  @ApiModelProperty("区")
  private String districtCode;

  @ApiModelProperty("区名称")
  private String districtName;

  /**
   * 经度
   */
  @ApiModelProperty("经度")
  private BigDecimal longitude;

  /**
   * 纬度
   */
  @ApiModelProperty("纬度")
  private BigDecimal latitude;

  /**
   * 联系人
   */
  @ApiModelProperty("联系人")
  private String contactPerson;

  /**
   * 手机号
   */
  @ApiModelProperty("手机号")
  private String mobileNumber;
}
