package com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 渠道组织关联终端vo
 *
 * @author pengxi
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ChannelOrgRelationTerminalVo", description = "渠道组织关联终端vo")
public class ChannelOrgRelationTerminalVo extends AbstractChannelOrgRelationVo {

  /**
   * 渠道组织名称
   */
  @ApiModelProperty(value = "渠道组织名称")
  private String channelOrgName;

  /**
   * 渠道组织层级
   */
  @ApiModelProperty(value = "渠道组织层级")
  private String channelOrgLevel;

  /**
   * 渠道组织类型
   */
  @ApiModelProperty(value = "渠道组织类型")
  private String channelOrgType;

  /**
   * 渠道组织描述
   */
  @ApiModelProperty(value = "渠道组织描述")
  private String channelOrgDesc;

  /**
   * 上级渠道组织编码
   */
  @ApiModelProperty("上级渠道组织编码")
  private String parentChannelOrgCode;

  /**
   * 上级渠道组织名称
   */
  @ApiModelProperty(value = "上级渠道组织名称")
  private String parentChannelOrgName;

  /**
   * 渠道组织层级
   */
  @ApiModelProperty(value = "渠道组织层级")
  private Integer channelOrgLevelNum;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  private String terminalName;

  /**
   * 高德地图ID
   */
  @ApiModelProperty("高德地图ID")
  private String amapId;

  /**
   * 终端类型
   */
  @ApiModelProperty("终端类型")
  private String terminalType;

  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  private String channel;

  /**
   * 省
   */
  @ApiModelProperty("省编码")
  private String provinceCode;

  @ApiModelProperty("省名称")
  private String provinceName;

  /**
   * 市
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  @ApiModelProperty("市名称")
  private String cityName;

  /**
   * 区
   */
  @ApiModelProperty("区编码")
  private String districtCode;

  @ApiModelProperty("区名称")
  private String districtName;

  /**
   * 终端地址
   */
  @ApiModelProperty("终端地址")
  private String terminalAddress;

}
