package com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.register;

/**
 * 渠道组织关系注册器，所有渠道组织关系模块都需要实现此注册器
 *
 * @author pengxi
 */
public interface ChannelOrgRelationRegister {

  /**
   * 渠道组织关系中文名称
   * 具体渠道组织关系实现该方法，告知本渠道组织关系的中文名（注意，具体的渠道组织关系中，设定的该信息不能重复）
   */
  String getName();

  /**
   * 渠道组织关系key
   * 具体渠道组织关系实现该方法，告知本渠道组织关系的英文key（注意，具体的渠道组织关系中，设定的该信息不能重复）
   */
  String getKey();

  /**
   * 排序
   */
  default int sort() {
    return Integer.MIN_VALUE;
  }
}
