package com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.dto.ChannelOrgRelationTerminalDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.dto.ChannelOrgRelationTerminalPageDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.vo.ChannelOrgRelationTerminalVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 渠道组织关系通用service服务层
 *
 * @author pengxi
 */
public interface ChannelOrgRelationTerminalVoService {
  
  /**
   * 绑定关系
   *
   * @param relationDto
   */
  void bind(ChannelOrgRelationTerminalDto relationDto);

  /**
   * 删除关系
   *
   * @param ids
   */
  void deleteByIds(List<String> ids);

  /**
   * 按照实体中的（id）主键和关联类型（key）进行查询明细查询
   *
   * @param id
   * @return
   */
  ChannelOrgRelationTerminalVo findDetailsById(String id);

  /**
   * 多条件分页查询
   *
   * @param pageable
   * @param pageDto
   * @return
   */
  Page<ChannelOrgRelationTerminalVo> findByConditions(Pageable pageable, ChannelOrgRelationTerminalPageDto pageDto);
}
