package com.biz.crm.mdm.business.channel.org.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import lombok.Data;

/**
 * 渠道组织创建dto
 */
@Data
@ApiModel("渠道组织创建dto")
public class ChannelOrgCreateDto {

  @ApiModelProperty(value = "渠道组织编码")
  private String channelOrgCode;

  @ApiModelProperty(value = "渠道组织名称")
  private String channelOrgName;

  @ApiModelProperty(value = "渠道组织层级")
  private String channelOrgLevel;

  @ApiModelProperty(value = "渠道组织类型")
  private String channelOrgType;

  @ApiModelProperty(value = "渠道组织描述")
  private String channelOrgDesc;

  @ApiModelProperty("上级编码")
  private String parentCode;

  @ApiModelProperty("启用状态")
  private String enableStatus;

  /**
   * 外部系统编码
   */
  @ApiModelProperty("外部系统编码")
  private String extSystemCode;

  /**
   * 组织负责人
   */
  @ApiModelProperty("组织负责人")
  private String principalName;

  /**
   * 组织负责人手机号
   */
  @ApiModelProperty("组织负责人手机号")
  private String principalPhone;

  /**
   * 关联数据类型：new或null-新建，saleOrg-销售组织，saleTerminal-销售终端门店，saleDealer-销售经销商
   */
  @ApiModelProperty("关联数据类型：new或null-新建，saleOrg-销售组织，saleTerminal-销售终端门店，saleDealer-销售经销商")
  private String relationDataType;

  /**
   * 关联数据编码
   */
  @ApiModelProperty("关联数据编码")
  private String relationDataCode;
}
