package com.biz.crm.mdm.business.channel.org.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 渠道组织分页查询dto
 */
@Data
@ApiModel("渠道组织分页查询dto")
public class ChannelOrgPaginationDto extends TenantFlagOpDto {

  @ApiModelProperty(name = "ruleCode", value = "规则code查询用")
  private String ruleCode;

  @ApiModelProperty(name = "levelNum", value = "层级等级查询用")
  private Integer levelNum;

  @ApiModelProperty("ID集合")
  private List<String> ids;

  @ApiModelProperty(value = "渠道组织编码")
  private String channelOrgCode;

  @ApiModelProperty(value = "渠道组织名称")
  private String channelOrgName;

  @ApiModelProperty(value = "渠道组织层级")
  private String channelOrgLevel;

  @ApiModelProperty(value = "渠道组织类型")
  private String channelOrgType;

  @ApiModelProperty(value = "渠道组织描述")
  private String channelOrgDesc;

  @ApiModelProperty("上级编码")
  private String parentCode;

  @ApiModelProperty("渠道组织名称，模糊查询编码或名称")
  private String channelOrgCodeOrName;

  @ApiModelProperty("渠道组织编码，只查询当前渠道组织及下级")
  private String underChannelOrgCode;

  @ApiModelProperty("渠道组织编码，排除当前层级和下级")
  private String notUnderChannelOrgCode;

  @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
  private String selectedCode;

  @ApiModelProperty("回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
  private List<String> selectedCodeList;

  /**
   * 渠道组织ruleCode，只查询当前渠道组织及下级
   */
  private String underThisRuleCode;

  /**
   * 渠道组织ruleCode，排除当前渠道组织及下级
   */
  private String notUnderThisRuleCode;
}
