package com.biz.crm.mdm.business.channel.org.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @Author dexin.liu
 * @Date 2022/12/23 19:03
 * @Description
 * @Version 1.0.0
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ChannelOrgTenantVo", description = "渠道租户信息vo")
public class ChannelOrgTenantVo {

  /**
   * 渠道组织编码
   */
  @ApiModelProperty("渠道组织编码")
  private String channelOrgCode;

  /**
   * 平台使用状态：1-激活，2-停用
   */
  @ApiModelProperty("平台使用状态")
  private Integer useStatus;

  /**
   * 系统负责人
   */
  @ApiModelProperty("系统负责人")
  private String managerName;

  /**
   * 系统负责人手机号
   */
  @ApiModelProperty("系统负责人手机号")
  private String managerPhone;

  /**
   * 登录密码
   */
  @ApiModelProperty("登录密码")
  private String managerPassword;

  /**
   * 系统来源  dataCenter-数据中台，doubleCenter-双中心
   */
  @ApiModelProperty("系统来源  dataCenter-数据中台，doubleCenter-双中心")
  private String source;


}
