package com.biz.crm.mdm.business.cost.center.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.cost.center.feign.feign.internal.CostCenterVoServiceFeignImpl;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/12/3 14:39
 * @description: 成本中心feign
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-mdm}",
        path = "crm-mdm",
        fallbackFactory = CostCenterVoServiceFeignImpl.class)
public interface CostCenterVoServiceFeign {

    @GetMapping("/v1/costCenter/findByCodes")
    Result<List<CostCenterVo>> findByCodes(@RequestParam("costCenterCodes") List<String> costCenterCodes,
                                           @RequestParam("effective") String effective);

}
