package com.biz.crm.mdm.business.cost.center.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.cost.center.feign.feign.CostCenterVoServiceFeign;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/12/3 14:39
 * @description: 成本中心feign熔断实现
 */
@Component
public class CostCenterVoServiceFeignImpl implements FallbackFactory<CostCenterVoServiceFeign> {
    @Override
    public CostCenterVoServiceFeign create(Throwable cause) {
        return new CostCenterVoServiceFeign() {
            @Override
            public Result<List<CostCenterVo>> findByCodes(List<String> costCenterCodes, String effective) {
                throw new UnsupportedOperationException("通过成本中心编码批量查询成本中心数据熔断");
            }
        };
    }
}
