package com.biz.crm.mdm.business.cost.center.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.cost.center.local.service.ICostCenterRelationService;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterRelationDto;
import com.biz.crm.mdm.business.cost.center.sdk.service.CostCenterVoService;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterWithholdingDetailDto;
import com.biz.crm.mdm.business.cost.center.sdk.service.ICostCenterRelationVoService;
import com.biz.crm.mdm.business.cost.center.sdk.service.CostCenterVoService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterRelationVo;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Map;


/**
 * 成本中心映射关系
 * @author YangWei
 * @date 2023-03-22 11:19:49
 */
@Slf4j
@RestController
@RequestMapping("/v1/costCenterRelation")
@Api(tags = "MA成本中心映射关系")
public class ICostCenterRelationController {

    @Resource
    private ICostCenterRelationService iCostCenterRelationService;
    @Autowired(required = false)
    private CostCenterVoService costCenterVoService;

    @Autowired(required = false)
    private ICostCenterRelationVoService iCostCenterRelationVoService;

    /**
     * 新增
     * @param dto
     * @return {@link Result}<{@link ?}>
     */
    @ApiOperation(value = "新增")
    @PostMapping(value = "")
    public Result<?> create(@RequestBody CostCenterRelationDto dto) {
        try {
            this.iCostCenterRelationService.create(dto);
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("{id}")
    public Result<CostCenterRelationVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
        try {
            CostCenterRelationVo relationVo = this.iCostCenterRelationService.findById(id);
            return Result.ok(relationVo);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 编辑
     *
     * @param price
     * @return
     */
    @ApiOperation(value = "编辑")
    @PatchMapping(value = "")
    public Result<?> update(@RequestBody CostCenterRelationDto dto) {
        try {
            this.iCostCenterRelationService.update(dto);
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param ids 主键结合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping("delete")
    public Result<?> delete(@RequestParam("ids") List<String> ids) {
        try {
            this.iCostCenterRelationService.delete(ids);
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 条件查询数据
     *
     * @return
     */
    @ApiOperation(value = "条件查询数据")
    @GetMapping("findByCondition")
    public Result<List<CostCenterRelationVo>> findByCondition(CostCenterRelationDto costCenterRelationDto) {
        try {
            List<CostCenterRelationVo> relationVos = this.costCenterVoService.findByCondition(costCenterRelationDto);
            return Result.ok(relationVos);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "预提明细关联成本中心专用")
    @PostMapping("withholdingDetailMap")
    public Result<Map<String, List<CostCenterRelationVo>>> withholdingDetailMap(@RequestBody CostCenterWithholdingDetailDto dto) {
        try {
            return Result.ok(this.iCostCenterRelationVoService.withholdingDetailMap(dto));
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
