package com.biz.crm.mdm.business.cost.center.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author: chenlong
 * @date: 2022/12/3 11:16
 * @description: 成本中心实体类
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CostCenter", description = "成本中心实体类")
@TableName("mdm_cost_center")
@Entity
@Table(name = "mdm_cost_center", indexes = {
        @Index(name = "mdm_cost_center_index1", columnList = "cost_center_code", unique = false),
        @Index(name = "mdm_cost_center_index2", columnList = "cost_center_code,company_code,profit_center_code", unique = true),
})
@org.hibernate.annotations.Table(appliesTo = "mdm_cost_center", comment = "成本中心实体类")
public class CostCenter extends TenantFlagOpEntity {

    /**
     * 成本中心编码
     */
    @ApiModelProperty("成本中心编码")
    @TableField(value = "cost_center_code")
    @Column(name = "cost_center_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 成本中心编码 '")
    private String costCenterCode;

    /**
     * 成本中心名称
     */
    @ApiModelProperty("成本中心名称")
    @TableField(value = "cost_center_name")
    @Column(name = "cost_center_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 成本中心名称 '")
    private String costCenterName;

    /**
     * 公司代码
     */
    @ApiModelProperty("公司代码")
    @TableField(value = "company_code")
    @Column(name = "company_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 公司代码 '")
    private String companyCode;

    /**
     * 利润中心编码
     */
    @ApiModelProperty("利润中心编码")
    @TableField(value = "profit_center_code")
    @Column(name = "profit_center_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 利润中心编码 '")
    private String profitCenterCode;

    /**
     * 利润中心名称
     */
    @ApiModelProperty("利润中心名称")
    @TableField(value = "profit_center_name")
    @Column(name = "profit_center_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 利润中心名称 '")
    private String profitCenterName;

    /**
     * 有效开始时间
     */
    @ApiModelProperty("有效开始时间")
    @TableField(value = "begin_time")
    @Column(name = "begin_time", columnDefinition = "datetime COMMENT '有效开始时间'")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date beginTime;

    /**
     * 有效结束时间
     */
    @ApiModelProperty("有效结束时间")
    @TableField(value = "end_time")
    @Column(name = "end_time", columnDefinition = "datetime COMMENT '有效结束时间'")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endTime;
}
