package com.biz.crm.mdm.business.cost.center.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.cost.center.local.entity.CostCenter;
import com.biz.crm.mdm.business.cost.center.local.entity.CostCenterRelation;
import com.biz.crm.mdm.business.cost.center.local.mapper.CostCenterMapper;
import com.biz.crm.mdm.business.cost.center.local.mapper.ICostCenterRelationMapper;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterRelationDto;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterRelationVo;
import org.springframework.beans.factory.annotation.Autowired;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterWithholdingDetailDto;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterRelationVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterRelationDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Description 成本中心映射数据层
 * @Author YangWei
 * @Date 2023/3/22 上午11:33
 */
@Component
public class ICostCenterRelationRepository extends ServiceImpl<ICostCenterRelationMapper, CostCenterRelation> {
    @Autowired(required = false)
    private ICostCenterRelationMapper iCostCenterRelationMapper;

    /**
     * 删除数据
     * @param ids
     */
    public void delete(List<String> ids) {
        this.lambdaUpdate().in(CostCenterRelation::getId, ids)
            .remove();
    }

    /**
     * 通过唯一key查询数据
     * @param uniqueKey
     * @return {@link CostCenterRelation}
     */
    public CostCenterRelation findByUniqueKey(String uniqueKey) {
        return this.lambdaQuery().eq(CostCenterRelation::getUniqueKey, uniqueKey)
            .eq(CostCenterRelation::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .one();
    }

    public List<CostCenterRelationVo> findByCondition(CostCenterRelationDto costCenterRelationDto) {
        return iCostCenterRelationMapper.findByCondition(costCenterRelationDto);
    }

    /**
     * 预提明细关联成本中心专用
     *
     * @param dto
     * @return
     */
    public List<CostCenterRelationVo> withholdingDetailMap(CostCenterWithholdingDetailDto dto) {
        return iCostCenterRelationMapper.withholdingDetailList(dto, TenantUtils.getTenantCode());
    }
}